-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;


--
-- Create schema ecommerce
--

-- CREATE DATABASE IF NOT EXISTS ecommerce;
-- USE ecommerce;

--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `id_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `catalog_master_id` int(11) NOT NULL,
  `language` varchar(20) DEFAULT NULL,
  `catalog_num` int(11) NOT NULL,
  `catalog_code` varchar(60) NOT NULL,
  `description` varchar(100) DEFAULT NULL,
  `group_num` int(11) DEFAULT NULL,
  PRIMARY KEY (`id_catalog`),
  UNIQUE KEY `idx_group_language` (`group_num`,`language`,`catalog_num`),
  KEY `fk_catalog_catalog_master1_idx` (`catalog_master_id`),
  KEY `idx_catalog_num` (`catalog_num`),
  KEY `idx_group_num` (`group_num`,`catalog_num`) USING BTREE,
  CONSTRAINT `fk_catalog_catalog_master1` FOREIGN KEY (`catalog_master_id`) REFERENCES `catalog_master` (`id_catalog_master`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`id_catalog`,`catalog_master_id`,`language`,`catalog_num`,`catalog_code`,`description`,`group_num`) VALUES 
 (1,1,'',0,'Spanish','',NULL),
 (2,1,'',1,'English','',NULL),
 (3,2,'Spanish',0,'Vinos','',NULL),
 (4,2,'English',0,'Wines','',NULL),
 (5,3,'Spanish',0,'Región Rioja','',0),
 (6,3,'English',0,'Rioja Region','',0),
 (7,2,'Spanish',1,'Cervezas','',NULL),
 (8,2,'English',1,'Beers','',NULL),
 (9,3,'Spanish',3,'de Bégica','',1),
 (10,3,'English',3,'from Belgium','',1),
 (11,4,'English',0,'Order in preparation','',NULL),
 (12,4,'Spanish',0,'Pedido en preparación','',NULL),
 (13,4,'English',1,'Order issued','',NULL),
 (14,4,'Spanish',1,'Pedido emitido','',NULL),
 (15,4,'English',2,'Required order','',NULL),
 (16,4,'Spanish',2,'Pedido recibido','',NULL),
 (17,4,'English',3,'Accepted order','',NULL),
 (18,4,'Spanish',3,'Pedido aceptado','',NULL),
 (19,4,'English',4,'Paid invoice','',NULL),
 (20,4,'Spanish',4,'Factura pagada','',NULL),
 (21,3,'Spanish',1,'Región Ribera','',0),
 (22,3,'English',1,'Ribera Region','',0),
 (23,5,'English',0,'Order in preparation','',NULL),
 (24,5,'Spanish',0,'Pedido en preparación','',NULL),
 (25,5,'Spanish',1,'Pedido cerrado y confirmado','',NULL),
 (26,5,'Spanish',2,'Pedido pagado','',NULL),
 (27,5,'Spanish',3,'En preparación de envío','',NULL),
 (28,5,'Spanish',4,'Pedido enviado','',NULL),
 (29,5,'Spanish',5,'Pedido entregado','',NULL),
 (30,5,'Spanish',6,'Pedido devuelto','',NULL),
 (31,5,'Spanish',7,'Devolución recibida en almacen','',NULL),
 (32,5,'Spanish',8,'Devolución abonada al cliente','',NULL),
 (33,5,'English',1,'Order closed and confirmed ','',NULL),
 (34,5,'English',2,'Order paid','',NULL),
 (35,5,'English',3,'In preparation of shipping','',NULL),
 (36,5,'English',4,'Order Sent','',NULL),
 (37,5,'English',5,'Order delivered','',NULL),
 (38,5,'English',6,'Order returned','',NULL),
 (39,5,'English',7,'Return received in Stock','',NULL),
 (40,5,'English',8,'Return paid to the customer','',NULL),
 (41,2,'Spanish',3,'Electrónica','Electrónica',NULL),
 (42,2,'English',3,'Electronics','',NULL),
 (43,3,'Spanish',4,'Portátiles','',3),
 (44,3,'English',4,'Laptops','',3);
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `catalog_master`
--

DROP TABLE IF EXISTS `catalog_master`;
CREATE TABLE `catalog_master` (
  `id_catalog_master` int(11) NOT NULL AUTO_INCREMENT,
  `code_master` varchar(10) NOT NULL,
  `description` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id_catalog_master`),
  KEY `idx_code_master` (`code_master`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `catalog_master`
--

/*!40000 ALTER TABLE `catalog_master` DISABLE KEYS */;
INSERT INTO `catalog_master` (`id_catalog_master`,`code_master`,`description`) VALUES 
 (1,'LANGUAGE','Idiomas'),
 (2,'GROUP_PROD','Grupo de Productos'),
 (3,'TYPE_PROD','Tipología de producto'),
 (4,'DEL_STATUS','Estados de los Pedidos'),
 (5,'ORD_STATUS','Estados de Ventas');
/*!40000 ALTER TABLE `catalog_master` ENABLE KEYS */;


--
-- Definition of table `customers`
--

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `id_customers` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `email_address` varchar(100) NOT NULL,
  `nick` varchar(100) NOT NULL,
  `telephone` varchar(12) NOT NULL,
  `postal_address` varchar(300) NOT NULL,
  `city` varchar(100) NOT NULL,
  `code_postal` varchar(10) NOT NULL,
  `password` varchar(200) NOT NULL,
  `has_newsletter` int(11) NOT NULL DEFAULT '0',
  `is_blocked` int(11) NOT NULL DEFAULT '0',
  `date_blocked` datetime DEFAULT NULL,
  `active` int(11) DEFAULT NULL,
  `reset_token` varchar(50) DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id_customers`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `customers`
--

/*!40000 ALTER TABLE `customers` DISABLE KEYS */;
INSERT INTO `customers` (`id_customers`,`name`,`email_address`,`nick`,`telephone`,`postal_address`,`city`,`code_postal`,`password`,`has_newsletter`,`is_blocked`,`date_blocked`,`active`,`reset_token`,`reset_date`) VALUES 
 (1,'Fernando Humanes','info@fhumanes.com','fhumanes','34630630630','...','Madrid','28045','ec4202adccd2b450b143fe520d09e2c6',0,0,NULL,1,'',NULL),
 (2,'Fernando Humanes','fernandohumanes@gmail.com','humanes','+34630630630','Mi casa','Madrid','28803','996daee3fb7e636c0f8b53a42c5b4c88',1,0,NULL,1,'',NULL);
/*!40000 ALTER TABLE `customers` ENABLE KEYS */;


--
-- Definition of table `delivery_note`
--

DROP TABLE IF EXISTS `delivery_note`;
CREATE TABLE `delivery_note` (
  `id_delivery_note` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturers_id` int(11) NOT NULL,
  `delivery_status` int(11) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  `last_modified` datetime NOT NULL,
  `product_count` int(11) NOT NULL,
  `amount_total` decimal(15,4) NOT NULL,
  `tax_total` decimal(15,4) NOT NULL,
  `discounts_total` decimal(15,4) NOT NULL,
  `total_total` decimal(15,4) NOT NULL,
  PRIMARY KEY (`id_delivery_note`),
  KEY `fk_delivery_note_manufacturers1_idx` (`manufacturers_id`),
  CONSTRAINT `fk_delivery_note_manufacturers1` FOREIGN KEY (`manufacturers_id`) REFERENCES `manufacturers` (`id_manufacturers`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `delivery_note`
--

/*!40000 ALTER TABLE `delivery_note` DISABLE KEYS */;
INSERT INTO `delivery_note` (`id_delivery_note`,`manufacturers_id`,`delivery_status`,`date_added`,`last_modified`,`product_count`,`amount_total`,`tax_total`,`discounts_total`,`total_total`) VALUES 
 (2,1,3,'2021-07-16 14:01:45','2021-07-24 20:19:33',1,'176.0000','36.9600','0.0000','212.9600'),
 (3,1,0,'2021-07-20 13:35:33','2021-07-25 14:24:44',1,'159.4800','33.4908','1.0000','191.9708'),
 (4,2,0,'2021-07-24 20:57:41','2021-07-24 20:57:41',1,'150.0000','31.5000','0.0000','181.5000'),
 (5,1,0,'2021-07-25 18:37:49','2021-07-25 18:38:47',2,'320.0000','67.2000','3.0000','384.2000');
/*!40000 ALTER TABLE `delivery_note` ENABLE KEYS */;


--
-- Definition of table `delivery_products`
--

DROP TABLE IF EXISTS `delivery_products`;
CREATE TABLE `delivery_products` (
  `id_delivery_products` int(11) NOT NULL AUTO_INCREMENT,
  `delivery_note_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL,
  `price` decimal(15,4) NOT NULL,
  `amount` decimal(15,4) NOT NULL,
  `tax_amount` decimal(15,4) NOT NULL,
  `total` decimal(15,4) NOT NULL,
  `date_added` datetime NOT NULL,
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`id_delivery_products`),
  KEY `fk_delivery_products_delivery_note1_idx` (`delivery_note_id`),
  KEY `fk_delivery_products_products1_idx` (`products_id`),
  CONSTRAINT `fk_delivery_products_delivery_note1` FOREIGN KEY (`delivery_note_id`) REFERENCES `delivery_note` (`id_delivery_note`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_delivery_products_products1` FOREIGN KEY (`products_id`) REFERENCES `products` (`id_products`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `delivery_products`
--

/*!40000 ALTER TABLE `delivery_products` DISABLE KEYS */;
INSERT INTO `delivery_products` (`id_delivery_products`,`delivery_note_id`,`products_id`,`quantity`,`price`,`amount`,`tax_amount`,`total`,`date_added`,`last_modified`) VALUES 
 (1,2,1,10,'12.3500','123.5000','25.9350','149.4350','2021-07-16 14:05:40','2021-07-20 13:15:24'),
 (2,3,1,15,'10.6320','159.4800','33.4908','192.9708','2021-07-20 13:36:28','2021-07-20 13:36:28'),
 (3,2,2,5,'10.5000','52.5000','11.0250','63.5250','2021-07-20 17:23:11','2021-07-20 17:23:11'),
 (4,4,2,10,'15.0000','150.0000','31.5000','181.5000','2021-07-24 20:59:04','2021-07-24 20:59:04'),
 (5,3,1,1,'14.0000','14.0000','2.9400','16.9400','2021-07-25 14:25:11','2021-07-25 14:25:11'),
 (6,5,1,10,'14.0000','140.0000','29.4000','169.4000','2021-07-25 18:38:46','2021-07-25 18:38:46'),
 (7,5,3,10,'18.0000','180.0000','37.8000','217.8000','2021-07-25 18:38:47','2021-07-25 18:38:47');
/*!40000 ALTER TABLE `delivery_products` ENABLE KEYS */;


--
-- Definition of table `ecommerce_audit`
--

DROP TABLE IF EXISTS `ecommerce_audit`;
CREATE TABLE `ecommerce_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `ip` varchar(40) NOT NULL,
  `user` varchar(300) DEFAULT NULL,
  `table` varchar(300) DEFAULT NULL,
  `action` varchar(250) NOT NULL,
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=76 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ecommerce_audit`
--

/*!40000 ALTER TABLE `ecommerce_audit` DISABLE KEYS */;
INSERT INTO `ecommerce_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (1,'2021-08-18 18:48:17','127.0.0.1','info@humanes','customers','failed login',''),
 (2,'2021-08-18 18:55:37','127.0.0.1','','customers','failed login',''),
 (3,'2021-08-18 18:57:28','127.0.0.1','','customers','failed login',''),
 (4,'2021-08-18 18:58:48','127.0.0.1','info@fhumanes.com','customers','change password',''),
 (5,'2021-08-18 18:59:30','127.0.0.1','','customers','failed login',''),
 (6,'2021-08-18 19:04:13','127.0.0.1','','customers','failed login',''),
 (7,'2021-08-18 19:04:55','127.0.0.1','','customers','failed login',''),
 (8,'2021-08-18 19:08:11','127.0.0.1','','customers','failed login',''),
 (9,'2021-08-18 19:09:13','127.0.0.1','fhumanes','customers','change password',''),
 (10,'2021-08-18 19:09:30','127.0.0.1','','customers','failed login',''),
 (11,'2021-08-18 19:09:39','127.0.0.1','','customers','failed login',''),
 (12,'2021-08-18 19:15:46','127.0.0.1','humanes','customers','login',''),
 (13,'2021-08-18 19:16:30','127.0.0.1','humanes','customers','edit','---Keys\r\nnick : humanes\r\n'),
 (14,'2021-08-18 19:16:58','127.0.0.1','humanes','customers','logout',''),
 (15,'2021-08-18 19:23:26','127.0.0.1','','customers','failed login',''),
 (16,'2021-08-18 19:33:11','127.0.0.1','','customers','failed login',''),
 (17,'2021-08-18 19:33:39','127.0.0.1','humanes','customers','login',''),
 (18,'2021-08-18 19:36:10','127.0.0.1','humanes','customers','logout',''),
 (19,'2021-08-18 19:36:33','127.0.0.1','humanes','customers','login',''),
 (20,'2021-08-18 19:37:50','127.0.0.1','humanes','customers','logout',''),
 (21,'2021-08-18 19:38:06','127.0.0.1','humanes','customers','login',''),
 (22,'2021-08-18 19:38:18','127.0.0.1','humanes','customers','logout',''),
 (23,'2021-08-18 19:45:50','127.0.0.1','humanes','customers','login',''),
 (24,'2021-08-18 19:47:24','127.0.0.1','humanes','customers','logout',''),
 (25,'2021-08-18 20:11:01','127.0.0.1','humanes','customers','login',''),
 (26,'2021-08-19 13:49:57','127.0.0.1','humanes','customers','logout',''),
 (27,'2021-08-19 13:50:42','127.0.0.1','humanes','customers','login',''),
 (28,'2021-08-19 14:04:05','127.0.0.1','humanes','customers','logout',''),
 (29,'2021-08-19 18:42:40','127.0.0.1','humanes','customers','login',''),
 (30,'2021-08-20 12:30:45','127.0.0.1','humanes','customers','logout',''),
 (31,'2021-08-20 14:35:07','127.0.0.1','humanes','customers','login',''),
 (32,'2021-08-20 20:30:48','127.0.0.1','humanes','customers','logout',''),
 (33,'2021-08-21 19:34:51','127.0.0.1','humanes','customers','login',''),
 (34,'2021-08-21 20:35:32','127.0.0.1','humanes','customers','logout',''),
 (35,'2021-08-21 20:57:16','127.0.0.1','humanes','customers','login',''),
 (36,'2021-08-22 19:46:03','127.0.0.1','humanes','customers','logout',''),
 (37,'2021-08-22 20:05:33','127.0.0.1','humanes','customers','login',''),
 (38,'2021-08-22 20:34:31','127.0.0.1','humanes','customers','logout',''),
 (39,'2021-08-22 20:34:41','127.0.0.1','humanes','customers','login',''),
 (40,'2021-08-22 20:35:25','127.0.0.1','humanes','customers','logout',''),
 (41,'2021-08-22 20:35:41','127.0.0.1','humanes','customers','login',''),
 (42,'2021-08-22 21:10:25','127.0.0.1','humanes','customers','logout',''),
 (43,'2021-08-22 21:10:32','127.0.0.1','humanes','customers','login',''),
 (44,'2021-08-23 19:45:32','127.0.0.1','humanes','customers','login',''),
 (45,'2021-08-23 19:47:14','127.0.0.1','humanes','customers','logout',''),
 (46,'2021-08-23 19:48:01','127.0.0.1','humanes','customers','login',''),
 (47,'2021-08-23 19:49:12','127.0.0.1','humanes','customers','logout',''),
 (48,'2021-08-23 19:49:24','127.0.0.1','humanes','customers','login',''),
 (49,'2021-08-23 20:01:36','127.0.0.1','humanes','customers','login',''),
 (50,'2021-08-23 20:03:30','127.0.0.1','humanes','customers','login',''),
 (51,'2021-08-23 20:04:21','::1','humanes','customers','failed login',''),
 (52,'2021-08-23 20:04:34','::1','humanes','customers','failed login',''),
 (53,'2021-08-23 20:04:39','::1','humanes2','customers','failed login',''),
 (54,'2021-08-23 20:07:35','::1','humanes','customers','change password',''),
 (55,'2021-08-23 20:08:02','::1','humanes','customers','login',''),
 (56,'2021-08-23 20:37:36','::1','humanes','customers','logout',''),
 (57,'2021-08-24 17:33:42','127.0.0.1','humanes','customers','logout',''),
 (58,'2021-08-24 17:33:49','127.0.0.1','humanes','customers','failed login',''),
 (59,'2021-08-24 17:34:07','127.0.0.1','humanes','customers','failed login',''),
 (60,'2021-08-24 17:34:17','127.0.0.1','humanes','customers','failed login',''),
 (61,'2021-08-24 17:35:22','127.0.0.1','humanes','customers','change password',''),
 (62,'2021-08-24 17:35:42','127.0.0.1','humanes','customers','login',''),
 (63,'2021-08-24 21:30:32','127.0.0.1','humanes','customers','logout',''),
 (64,'2021-08-24 21:30:39','127.0.0.1','humanes','customers','login',''),
 (65,'2021-08-25 18:30:48','127.0.0.1','humanes','customers','login',''),
 (66,'2021-08-25 19:05:07','127.0.0.1','humanes','customers','logout',''),
 (67,'2021-08-25 19:05:18','127.0.0.1','humanes','customers','login',''),
 (68,'2021-08-25 19:14:10','127.0.0.1','humanes','customers','logout',''),
 (69,'2021-08-25 19:21:27','127.0.0.1','humanes','customers','login',''),
 (70,'2021-08-25 20:05:08','::1','humanes','customers','login',''),
 (71,'2021-08-25 20:40:08','::1','humanes','customers','logout',''),
 (72,'2021-08-27 19:42:02','127.0.0.1','humanes','customers','logout',''),
 (73,'2021-08-27 19:42:41','127.0.0.1','humanes','customers','login',''),
 (74,'2021-08-27 19:48:21','127.0.0.1','humanes','customers','logout',''),
 (75,'2021-08-27 19:48:28','127.0.0.1','humanes','customers','login','');
/*!40000 ALTER TABLE `ecommerce_audit` ENABLE KEYS */;


--
-- Definition of table `ecommerce_priv_audit`
--

DROP TABLE IF EXISTS `ecommerce_priv_audit`;
CREATE TABLE `ecommerce_priv_audit` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `datetime` datetime NOT NULL,
  `ip` varchar(40) NOT NULL,
  `user` varchar(300) DEFAULT NULL,
  `table` varchar(300) DEFAULT NULL,
  `action` varchar(250) NOT NULL,
  `description` mediumtext,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=327 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ecommerce_priv_audit`
--

/*!40000 ALTER TABLE `ecommerce_priv_audit` DISABLE KEYS */;
INSERT INTO `ecommerce_priv_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (1,'2021-07-12 19:36:52','127.0.0.1','admin','users','login',''),
 (2,'2021-07-12 19:39:54','127.0.0.1','admin','users','edit','---Keys\r\nlogin : admin\r\n---Fields\r\nname [old]: \r\nname [new]: Administraor\r\n'),
 (3,'2021-07-12 19:40:07','127.0.0.1','admin','users','logout',''),
 (4,'2021-07-12 19:40:10','127.0.0.1','admin','users','login',''),
 (5,'2021-07-14 18:47:27','127.0.0.1','admin','type_master','add','---Keys\r\nid_type_master : 1\r\n---Fields\r\nname_master [new]: Electrodomésticos\r\n'),
 (6,'2021-07-14 18:55:51','127.0.0.1','admin','catalog_master','add','---Keys\r\nid_catalog_master : 1\r\n---Fields\r\ncode_master [new]: LANGUAGE\r\ndescription [new]: Idiomas\r\n'),
 (7,'2021-07-14 18:57:22','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 1\r\n---Fields\r\ncatalog_master_id [new]: 1\r\nlanguage [new]: spanish\r\ncatalog_num [new]: 00\r\ncatalog_code [new]: Español\r\n'),
 (8,'2021-07-14 18:58:09','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 2\r\n---Fields\r\ncatalog_master_id [new]: 1\r\nlanguage [new]: english\r\ncatalog_num [new]: 01\r\ncatalog_code [new]: English\r\n'),
 (9,'2021-07-14 18:58:34','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 2\r\n---Fields\r\nlanguage [old]: english\r\nlanguage [new]: \r\n'),
 (10,'2021-07-14 18:58:40','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 1\r\n---Fields\r\nlanguage [old]: spanish\r\nlanguage [new]: \r\n'),
 (11,'2021-07-14 19:10:41','127.0.0.1','admin','catalog_master','add','---Keys\r\nid_catalog_master : 2\r\n---Fields\r\ncode_master [new]: GROUP_PROC\r\ndescription [new]: Grupo de Productos\r\n'),
 (12,'2021-07-14 19:14:30','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 3\r\n---Fields\r\ncatalog_master_id [new]: 2\r\nlanguage [new]: Español\r\ncatalog_num [new]: 00\r\ncatalog_code [new]: Vinos\r\n'),
 (13,'2021-07-14 19:14:59','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 4\r\n---Fields\r\ncatalog_master_id [new]: 2\r\nlanguage [new]: English\r\ncatalog_num [new]: 00\r\ncatalog_code [new]: Wines\r\ndescription [new]: Vinos\r\n'),
 (14,'2021-07-14 19:15:09','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 4\r\n---Fields\r\ndescription [old]: Vinos\r\ndescription [new]: \r\n'),
 (15,'2021-07-14 19:16:51','127.0.0.1','admin','catalog_master','edit','---Keys\r\nid_catalog_master : 2\r\n---Fields\r\ncode_master [old]: GROUP_PROC\r\ncode_master [new]: GROUP_PROD\r\n'),
 (16,'2021-07-14 19:17:25','127.0.0.1','admin','catalog_master','add','---Keys\r\nid_catalog_master : 3\r\n---Fields\r\ncode_master [new]: TYPE_PROD\r\ndescription [new]: Tipología de producto\r\n'),
 (17,'2021-07-14 19:18:02','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 5\r\n---Fields\r\ncatalog_master_id [new]: 3\r\nlanguage [new]: Español\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Rioja\r\ngroup_num [new]: 0\r\n'),
 (18,'2021-07-14 19:19:53','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 6\r\n---Fields\r\ncatalog_master_id [new]: 3\r\nlanguage [new]: English\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Rioja Region\r\ngroup_num [new]: 0\r\n'),
 (19,'2021-07-14 19:20:08','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 5\r\n---Fields\r\ncatalog_code [old]: Rioja\r\ncatalog_code [new]: Región Rioja\r\n'),
 (20,'2021-07-14 19:30:34','127.0.0.1','admin','type_master','add','---Keys\r\nid_catalog : 7\r\n---Fields\r\nlanguage [new]: Español\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Cervezas\r\ncatalog_master_id [new]: 2\r\n'),
 (21,'2021-07-14 19:31:01','127.0.0.1','admin','type_master','add','---Keys\r\nid_catalog : 8\r\n---Fields\r\nlanguage [new]: English\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Beers\r\ncatalog_master_id [new]: 2\r\n'),
 (22,'2021-07-14 20:42:45','127.0.0.1','admin','type','add','---Keys\r\nid_catalog : 9\r\n---Fields\r\nlanguage [new]: Español\r\ncatalog_num [new]: 00\r\ncatalog_code [new]: de Bégica\r\ngroup_num [new]: 1\r\ncatalog_master_id [new]: 3\r\n'),
 (23,'2021-07-14 20:46:24','127.0.0.1','admin','type','add','---Keys\r\nid_catalog : 10\r\n---Fields\r\nlanguage [new]: English\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: from Belgium\r\ngroup_num [new]: 1\r\ncatalog_master_id [new]: 3\r\n'),
 (24,'2021-07-14 21:03:10','127.0.0.1','admin','tax','add','---Keys\r\nid_tax : 1\r\n---Fields\r\ntax_code [new]: Reducido\r\ntax_amount [new]: 10\r\nDescription [new]: IVA reducido\r\n'),
 (25,'2021-07-14 21:04:39','127.0.0.1','admin','tax','add','---Keys\r\nid_tax : 2\r\n---Fields\r\ntax_code [new]: General\r\ntax_amount [new]: 21\r\nDescription [new]: IVA General\r\n'),
 (26,'2021-07-15 18:14:37','127.0.0.1','admin','users','logout',''),
 (27,'2021-07-15 18:14:41','127.0.0.1','admin','users','login',''),
 (28,'2021-07-15 18:15:26','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 1\r\n---Fields\r\ncatalog_code [old]: Español\r\ncatalog_code [new]: Spanish\r\n'),
 (29,'2021-07-15 18:19:23','127.0.0.1','admin','type_master','edit','---Keys\r\nid_catalog : 3\r\n---Fields\r\nlanguage [old]: Español\r\nlanguage [new]: Spanish\r\n'),
 (30,'2021-07-15 18:19:37','127.0.0.1','admin','type_master','edit','---Keys\r\nid_catalog : 7\r\n---Fields\r\nlanguage [old]: Español\r\nlanguage [new]: Spanish\r\n'),
 (31,'2021-07-15 18:20:00','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 5\r\n---Fields\r\nlanguage [old]: Español\r\nlanguage [new]: Spanish\r\n'),
 (32,'2021-07-15 18:20:09','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 9\r\n---Fields\r\nlanguage [old]: Español\r\nlanguage [new]: Spanish\r\n'),
 (33,'2021-07-15 18:30:55','127.0.0.1','admin','manufacturers','add','---Keys\r\nid_manufacturers : 1\r\n---Fields\r\nmanufacturer_name [new]: Bodegas Pesquera\r\nnif [new]: 5M\r\nemail_address [new]: info@perquera.com\r\n'),
 (34,'2021-07-15 18:31:27','127.0.0.1','admin','products','add','---Keys\r\nid_products : 1\r\n---Fields\r\ntype_num [new]: 0\r\ntax_id [new]: 2\r\nmanufacturers_id [new]: 1\r\nmodel [new]: Pesquera crianza\r\nprice [new]: 15.125\r\nquantity [new]: 0\r\ndate_added [new]: 2021-07-15 18:29:07\r\nlast_modified [new]: 2021-07-15 18:29:07\r\nquantity_order_min [new]: 1\r\nisVisible [new]: 0\r\nmaster_num [new]: 0\r\nisVirtual [new]: 0\r\n'),
 (35,'2021-07-15 18:54:44','127.0.0.1','admin','manufacturers','edit','---Keys\r\nid_manufacturers : 1\r\n---Fields\r\npostal_address [old]: \r\npostal_address [new]: Calle\r\ncity [old]: \r\ncity [new]: Rioja\r\n'),
 (36,'2021-07-15 19:02:09','127.0.0.1','admin','catalog_master','add','---Keys\r\nid_catalog_master : 4\r\n---Fields\r\ncode_master [new]: DEL_STATUS\r\ndescription [new]: Estados de los Pedidos\r\n'),
 (37,'2021-07-15 19:03:08','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 11\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Order in preparation\r\n'),
 (38,'2021-07-15 19:03:33','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 12\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Pedido en preparación\r\n'),
 (39,'2021-07-15 19:04:11','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 13\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Order issued\r\n'),
 (40,'2021-07-15 19:04:42','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 14\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Pedido emitido\r\n'),
 (41,'2021-07-15 19:05:40','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 15\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 2\r\ncatalog_code [new]: Required order\r\n'),
 (42,'2021-07-15 19:06:01','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 16\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 2\r\ncatalog_code [new]: Pedido recibido\r\n'),
 (43,'2021-07-15 19:06:57','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 17\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 3\r\ncatalog_code [new]: Accepted order\r\n'),
 (44,'2021-07-15 19:07:15','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 18\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 3\r\ncatalog_code [new]: Pedido aceptado\r\n'),
 (45,'2021-07-15 19:07:53','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 19\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: English\r\ncatalog_num [new]: 4\r\ncatalog_code [new]: Paid invoice\r\n'),
 (46,'2021-07-15 19:08:11','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 20\r\n---Fields\r\ncatalog_master_id [new]: 4\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 4\r\ncatalog_code [new]: Factura pagada\r\n'),
 (47,'2021-07-15 19:13:04','127.0.0.1','admin','delivery_note','add','---Keys\r\nid_delivery_note : 1\r\n---Fields\r\nmanufacturers_id [new]: 1\r\ndelivery_status [new]: 0\r\ndate_added [new]: 2021-07-15 19:11:52\r\nlast_modified [new]: 2021-07-15 19:11:52\r\nproduct_count [new]: 0\r\n'),
 (48,'2021-07-15 20:08:13','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: \r\ndescription [new]: #spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano spanish#  #english Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel english# \r\nlast_modified [old]: 2021-07-15 18:29:07\r\nlast_modified [new]: 2021-07-15 20:05:42\r\n'),
 (49,'2021-07-16 13:57:23','127.0.0.1','admin','delivery_note','delete','---Keys\r\nid_delivery_note : 1\r\n---Fields\r\nmanufacturers_id [old]: 1\r\ndelivery_status [old]: 0\r\ndate_added [old]: 2021-07-15 19:11:52\r\nlast_modified [old]: 2021-07-15 19:11:52\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ndiscounts_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (50,'2021-07-16 14:03:47','127.0.0.1','admin','delivery_note','add','---Keys\r\nid_delivery_note : 2\r\n---Fields\r\nmanufacturers_id [new]: 1\r\ndelivery_status [new]: 0\r\ndate_added [new]: 2021-07-16 14:01:45\r\nlast_modified [new]: 2021-07-16 14:01:45\r\nproduct_count [new]: 0\r\n'),
 (51,'2021-07-16 14:05:40','127.0.0.1','admin','delivery_products','add','---Keys\r\nid_delivery_products : 1\r\n---Fields\r\ndelivery_note_id [new]: 2\r\nproducts_id [new]: 1\r\nquantity [new]: 10\r\nprice [new]: 13.25\r\ndate_added [new]: 2021-07-16 14:05:40\r\nlast_modified [new]: 2021-07-16 14:05:40\r\n'),
 (52,'2021-07-20 13:09:26','127.0.0.1','admin','delivery_products','edit','---Keys\r\nid_delivery_products : 1\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 1\r\namount [old]: 0.0000\r\namount [new]: 13\r\ntax_amount [old]: 0.0000\r\ntax_amount [new]: 2.73\r\ntotal [old]: 0.0000\r\ntotal [new]: 15.73\r\nlast_modified [old]: 2021-07-16 14:05:40\r\nlast_modified [new]: 2021-07-20 13:09:25\r\n'),
 (53,'2021-07-20 13:09:26','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 2\r\n---Fields\r\nlast_modified [old]: 2021-07-16 14:01:45\r\nlast_modified [new]: 2021-07-20 13:08:55\r\n'),
 (54,'2021-07-20 13:13:06','127.0.0.1','admin','delivery_products','edit','---Keys\r\nid_delivery_products : 1\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\namount [old]: 13.0000\r\namount [new]: 132.5\r\ntax_amount [old]: 2.7300\r\ntax_amount [new]: 27.825\r\ntotal [old]: 15.7300\r\ntotal [new]: 160.325\r\nlast_modified [old]: 2021-07-20 13:09:25\r\nlast_modified [new]: 2021-07-20 13:13:06\r\n'),
 (55,'2021-07-20 13:15:24','127.0.0.1','admin','delivery_products','edit','---Keys\r\nid_delivery_products : 1\r\n---Fields\r\nprice [old]: 13.2500\r\nprice [new]: 12.35\r\namount [old]: 132.5000\r\namount [new]: 123.5\r\ntax_amount [old]: 27.8250\r\ntax_amount [new]: 25.935\r\ntotal [old]: 160.3250\r\ntotal [new]: 149.435\r\nlast_modified [old]: 2021-07-20 13:13:06\r\nlast_modified [new]: 2021-07-20 13:15:24\r\n'),
 (56,'2021-07-20 13:18:19','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 2\r\n---Fields\r\nlast_modified [old]: 2021-07-20 13:08:55\r\nlast_modified [new]: 2021-07-20 13:17:46\r\nproduct_count [old]: 0\r\nproduct_count [new]: 1\r\namount_total [old]: 0.0000\r\namount_total [new]: 123.5\r\ntax_total [old]: 0.0000\r\ntax_total [new]: 25.935\r\ntotal_total [old]: 0.0000\r\ntotal_total [new]: 149.435\r\n'),
 (57,'2021-07-20 13:36:28','127.0.0.1','admin','delivery_note','add','---Keys\r\nid_delivery_note : 3\r\n---Fields\r\nmanufacturers_id [new]: 1\r\ndelivery_status [new]: 0\r\ndate_added [new]: 2021-07-20 13:35:33\r\nlast_modified [new]: 2021-07-20 13:35:33\r\nproduct_count [new]: 1\r\n'),
 (58,'2021-07-20 13:36:28','127.0.0.1','admin','delivery_products','add','---Keys\r\nid_delivery_products : 2\r\n---Fields\r\ndelivery_note_id [new]: 3\r\nproducts_id [new]: 1\r\nquantity [new]: 15\r\nprice [new]: 10.632\r\namount [new]: 159.48\r\ntax_amount [new]: 33.4908\r\ntotal [new]: 192.9708\r\ndate_added [new]: 2021-07-20 13:36:28\r\nlast_modified [new]: 2021-07-20 13:36:28\r\n'),
 (59,'2021-07-20 13:38:28','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-20 13:35:33\r\nlast_modified [new]: 2021-07-20 13:37:46\r\namount_total [old]: 0.0000\r\namount_total [new]: 159.48\r\ndiscounts_total [old]: 0.0000\r\ndiscounts_total [new]: 1\r\ntax_total [old]: 0.0000\r\ntax_total [new]: 33.4908\r\ntotal_total [old]: 0.0000\r\ntotal_total [new]: 191.9708\r\n'),
 (60,'2021-07-20 17:19:34','127.0.0.1','admin','manufacturers','add','---Keys\r\nid_manufacturers : 2\r\n---Fields\r\nmanufacturer_name [new]: Bodegas Protos\r\nnif [new]: 000000005M\r\nemail_address [new]: info@protos.com\r\npostal_address [new]: Bodegas Proto\r\ncity [new]: Valladolid\r\n'),
 (61,'2021-07-20 17:20:57','127.0.0.1','admin','type','add','---Keys\r\nid_catalog : 21\r\n---Fields\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Región Ribera\r\ngroup_num [new]: 0\r\ncatalog_master_id [new]: 3\r\n'),
 (62,'2021-07-20 17:21:23','127.0.0.1','admin','type','add','---Keys\r\nid_catalog : 22\r\n---Fields\r\nlanguage [new]: English\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Rivera Region\r\ngroup_num [new]: 0\r\ncatalog_master_id [new]: 3\r\n'),
 (63,'2021-07-20 17:21:52','127.0.0.1','admin','products','add','---Keys\r\nid_products : 2\r\n---Fields\r\ntype_num [new]: 1\r\ntax_id [new]: 2\r\nmanufacturers_id [new]: 2\r\nmodel [new]: Protos crianza\r\nprice [new]: 14.25\r\nquantity [new]: 0\r\ndate_added [new]: 2021-07-20 17:18:23\r\nlast_modified [new]: 2021-07-20 17:18:23\r\nquantity_order_min [new]: 1\r\nisVisible [new]: 0\r\nmaster_num [new]: 0\r\nisVirtual [new]: 0\r\n'),
 (64,'2021-07-20 17:22:18','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ntype_num [old]: 0\r\ntype_num [new]: 1\r\nlast_modified [old]: 2021-07-15 20:05:42\r\nlast_modified [new]: 2021-07-20 17:22:11\r\n'),
 (65,'2021-07-20 17:23:11','127.0.0.1','admin','delivery_products','add','---Keys\r\nid_delivery_products : 3\r\n---Fields\r\ndelivery_note_id [new]: 2\r\nproducts_id [new]: 2\r\nquantity [new]: 5\r\nprice [new]: 10.5\r\namount [new]: 52.5\r\ntax_amount [new]: 11.025\r\ntotal [new]: 63.525\r\ndate_added [new]: 2021-07-20 17:23:11\r\nlast_modified [new]: 2021-07-20 17:23:11\r\n'),
 (66,'2021-07-20 17:23:11','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 2\r\n---Fields\r\nlast_modified [old]: 2021-07-20 13:17:46\r\nlast_modified [new]: 2021-07-20 17:22:32\r\n'),
 (67,'2021-07-20 17:23:47','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 2\r\n---Fields\r\nlast_modified [old]: 2021-07-20 17:22:32\r\nlast_modified [new]: 2021-07-20 17:23:21\r\namount_total [old]: 123.5000\r\namount_total [new]: 176\r\ntax_total [old]: 25.9350\r\ntax_total [new]: 36.96\r\ntotal_total [old]: 149.4350\r\ntotal_total [new]: 212.96\r\n'),
 (68,'2021-07-20 17:27:59','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nisVirtual [old]: 0\r\nisVirtual [new]: 1\r\nlast_modified [old]: 2021-07-20 17:22:11\r\nlast_modified [new]: 2021-07-20 17:27:49\r\n'),
 (69,'2021-07-20 17:28:40','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nisVirtual [old]: 1\r\nisVirtual [new]: 0\r\nlast_modified [old]: 2021-07-20 17:27:49\r\nlast_modified [new]: 2021-07-20 17:28:33\r\n'),
 (70,'2021-07-20 17:29:46','127.0.0.1','admin','products','add','---Keys\r\nid_products : 3\r\n---Fields\r\ntype_num [new]: 1\r\ntax_id [new]: 2\r\nmanufacturers_id [new]: 1\r\nmodel [new]: Pesquera reserva\r\nprice [new]: 20.52\r\ndescription [new]: #spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano spanish#  #english Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel english# \r\nquantity [new]: 0\r\ndate_added [new]: 2021-07-15 18:29:07\r\nlast_modified [new]: 2021-07-20 17:28:33\r\nquantity_order_min [new]: 1\r\nisVisible [new]: 0\r\nmaster_num [new]: 0\r\nisVirtual [new]: 0\r\n'),
 (71,'2021-07-20 17:30:06','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\ndate_added [old]: 2021-07-15 18:29:07\r\ndate_added [new]: 2021-07-20 17:30:04\r\nlast_modified [old]: 2021-07-20 17:28:33\r\nlast_modified [new]: 2021-07-20 17:30:00\r\n'),
 (72,'2021-07-20 17:44:26','127.0.0.1','admin','catalog_master','add','---Keys\r\nid_catalog_master : 5\r\n---Fields\r\ncode_master [new]: 5\r\ndescription [new]: ORD_STATUS\r\n'),
 (73,'2021-07-20 17:44:57','127.0.0.1','admin','catalog_master','edit','---Keys\r\nid_catalog_master : 5\r\n---Fields\r\ncode_master [old]: 5\r\ncode_master [new]: ORD_STATUS\r\ndescription [old]: ORD_STATUS\r\ndescription [new]: Estados de Ventas\r\n'),
 (74,'2021-07-20 17:46:27','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 23\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Order in preparation\r\n'),
 (75,'2021-07-20 17:46:46','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 24\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Pedido en preparación\r\n'),
 (76,'2021-07-20 17:47:56','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 25\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Pedido cerrado y confirmado\r\n'),
 (77,'2021-07-20 17:48:16','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 26\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 2\r\ncatalog_code [new]: Pedido pagado\r\n'),
 (78,'2021-07-20 17:48:43','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 27\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 3\r\ncatalog_code [new]: En preparación de envío\r\n'),
 (79,'2021-07-20 17:49:04','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 28\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 4\r\ncatalog_code [new]: Pedido enviado\r\n'),
 (80,'2021-07-20 17:49:28','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 29\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 5\r\ncatalog_code [new]: Pedido entregado\r\n'),
 (81,'2021-07-20 17:50:02','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 30\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 6\r\ncatalog_code [new]: Pedido devuelto\r\n'),
 (82,'2021-07-20 17:50:31','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 31\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 7\r\ncatalog_code [new]: Devolución recibida en almacen\r\n'),
 (83,'2021-07-20 17:50:48','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 32\r\n---Fields\r\ncatalog_master_id [new]: 5\r\ncatalog_num [new]: 8\r\ncatalog_code [new]: Devolución abonada al cliente\r\n'),
 (84,'2021-07-20 17:52:53','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 33\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 1\r\ncatalog_code [new]: Order closed and confirmed \r\n'),
 (85,'2021-07-20 17:53:12','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 34\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 2\r\ncatalog_code [new]: Order paid\r\n'),
 (86,'2021-07-20 17:53:50','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 35\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 3\r\ncatalog_code [new]: In preparation of shipping\r\n'),
 (87,'2021-07-20 17:54:20','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 36\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 4\r\ncatalog_code [new]: Order Sent\r\n'),
 (88,'2021-07-20 17:54:47','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 37\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 5\r\ncatalog_code [new]: Order delivered\r\n'),
 (89,'2021-07-20 17:55:13','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 38\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 6\r\ncatalog_code [new]: Order returned\r\n'),
 (90,'2021-07-20 17:55:34','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 39\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 7\r\ncatalog_code [new]: Return received in Stock\r\n'),
 (91,'2021-07-20 17:55:57','127.0.0.1','admin','catalog','add','---Keys\r\nid_catalog : 40\r\n---Fields\r\ncatalog_master_id [new]: 5\r\nlanguage [new]: English\r\ncatalog_num [new]: 8\r\ncatalog_code [new]: Return paid to the customer\r\n'),
 (92,'2021-07-20 18:18:55','127.0.0.1','admin','customers','add','---Keys\r\nid_customers : 1\r\n---Fields\r\nname [new]: Fernando Humanes\r\nemail_address [new]: info@fhumanes.com\r\nnick [new]: fhumanes\r\ntelephone [new]: 34630630630\r\npostal_address [new]: ...\r\ncity [new]: Madrid\r\ncode_postal [new]: 28045\r\npassword [new]: fhumanes\r\nhas_newsletter [new]: 0\r\nis_blocked [new]: 0\r\n'),
 (93,'2021-07-20 18:28:13','127.0.0.1','admin','orders','add','---Keys\r\nid_orders : 1\r\n---Fields\r\ncustomers_id [new]: 1\r\norder_status [new]: 0\r\ndate_added [new]: 2021-07-20 18:26:41\r\nlast_modified [new]: 2021-07-20 18:26:41\r\nproduct_count [new]: 0\r\n'),
 (94,'2021-07-20 18:28:13','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 1\r\n---Fields\r\norders_id [new]: 1\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 1414\r\ndate_added [new]: 2021-07-20 18:28:13\r\nlast_modified [new]: 2021-07-20 18:28:13\r\n'),
 (95,'2021-07-20 18:38:02','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 1\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 2\r\nprice [old]: 1414.0000\r\nprice [new]: 15.125\r\namount [old]: 0.0000\r\namount [new]: 30.25\r\ntax_amount [old]: 0.0000\r\ntax_amount [new]: 6.3525\r\ntotal [old]: 0.0000\r\ntotal [new]: 36.6025\r\nlast_modified [old]: 2021-07-20 18:28:13\r\nlast_modified [new]: 2021-07-20 18:38:02\r\n'),
 (96,'2021-07-20 18:38:16','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 2\r\n---Fields\r\norders_id [new]: 1\r\nproducts_id [new]: 3\r\nquantity [new]: 1\r\nprice [new]: 20.52\r\namount [new]: 20.52\r\ntax_amount [new]: 4.3092\r\ntotal [new]: 24.8292\r\ndate_added [new]: 2021-07-20 18:38:16\r\nlast_modified [new]: 2021-07-20 18:38:16\r\n'),
 (97,'2021-07-20 18:42:12','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 2\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 0\r\nlast_modified [old]: 2021-07-20 18:38:16\r\nlast_modified [new]: 2021-07-20 18:42:11\r\n'),
 (98,'2021-07-20 18:49:24','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 2\r\n---Fields\r\nlast_modified [old]: 2021-07-20 18:42:11\r\nlast_modified [new]: 2021-07-20 18:49:24\r\n'),
 (99,'2021-07-20 18:49:31','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 2\r\n---Fields\r\nquantity [old]: 0\r\nquantity [new]: 1\r\ntax_amount [old]: 4.3092\r\ntax_amount [new]: 4.3092\r\nlast_modified [old]: 2021-07-20 18:49:24\r\nlast_modified [new]: 2021-07-20 18:49:31\r\n'),
 (100,'2021-07-20 18:49:38','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 2\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 0\r\namount [old]: 20.5200\r\namount [new]: 0\r\ntax_amount [old]: 4.3092\r\ntax_amount [new]: 0\r\ntotal [old]: 24.8292\r\ntotal [new]: 0\r\nlast_modified [old]: 2021-07-20 18:49:31\r\nlast_modified [new]: 2021-07-20 18:49:38\r\n'),
 (101,'2021-07-20 18:49:56','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 2\r\n---Fields\r\norders_id [old]: 1\r\nproducts_id [old]: 3\r\nquantity [old]: 0\r\nprice [old]: 20.5200\r\nproduct_price [old]: 20.5200\r\nproduct_tax [old]: 21.00\r\namount [old]: 0.0000\r\ntax_amount [old]: 0.0000\r\ntotal [old]: 0.0000\r\ndate_added [old]: 2021-07-20 18:38:16\r\nlast_modified [old]: 2021-07-20 18:49:38\r\n'),
 (102,'2021-07-20 19:08:06','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 1\r\n---Fields\r\nquantity [old]: 2\r\nquantity [new]: 1\r\namount [old]: 30.2500\r\namount [new]: 15.125\r\ntax_amount [old]: 6.3525\r\ntax_amount [new]: 3.17625\r\ntotal [old]: 36.6025\r\ntotal [new]: 18.30125\r\nlast_modified [old]: 2021-07-20 18:38:02\r\nlast_modified [new]: 2021-07-20 19:08:06\r\n'),
 (103,'2021-07-20 19:08:28','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 1\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\namount [old]: 15.1250\r\namount [new]: 151.25\r\ntax_amount [old]: 3.1763\r\ntax_amount [new]: 31.7625\r\ntotal [old]: 18.3013\r\ntotal [new]: 183.0125\r\nlast_modified [old]: 2021-07-20 19:08:06\r\nlast_modified [new]: 2021-07-20 19:08:28\r\n'),
 (104,'2021-07-20 19:09:17','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 1\r\n---Fields\r\nlast_modified [old]: 2021-07-20 18:26:41\r\nlast_modified [new]: 2021-07-20 19:08:16\r\ntotal_total [old]: 0.0000\r\ntotal_total [new]: 183.0125\r\n'),
 (105,'2021-07-20 19:18:29','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 1\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 1\r\namount [old]: 151.2500\r\namount [new]: 15.125\r\ntax_amount [old]: 31.7625\r\ntax_amount [new]: 3.17625\r\ntotal [old]: 183.0125\r\ntotal [new]: 18.30125\r\nlast_modified [old]: 2021-07-20 19:08:28\r\nlast_modified [new]: 2021-07-20 19:18:29\r\n'),
 (106,'2021-07-20 19:18:42','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 3\r\n---Fields\r\norders_id [new]: 1\r\nproducts_id [new]: 3\r\nquantity [new]: 10\r\nprice [new]: 20.52\r\namount [new]: 205.2\r\ntax_amount [new]: 43.092\r\ntotal [new]: 248.292\r\ndate_added [new]: 2021-07-20 19:18:42\r\nlast_modified [new]: 2021-07-20 19:18:42\r\n'),
 (107,'2021-07-20 19:18:59','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 3\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 1\r\namount [old]: 205.2000\r\namount [new]: 20.52\r\ntax_amount [old]: 43.0920\r\ntax_amount [new]: 4.3092\r\ntotal [old]: 248.2920\r\ntotal [new]: 24.8292\r\nlast_modified [old]: 2021-07-20 19:18:42\r\nlast_modified [new]: 2021-07-20 19:18:59\r\n'),
 (108,'2021-07-20 19:23:11','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 3\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\namount [old]: 20.5200\r\namount [new]: 205.2\r\ntax_amount [old]: 4.3092\r\ntax_amount [new]: 43.092\r\ntotal [old]: 24.8292\r\ntotal [new]: 248.292\r\nlast_modified [old]: 2021-07-20 19:18:59\r\nlast_modified [new]: 2021-07-20 19:23:11\r\n'),
 (109,'2021-07-20 19:27:47','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 1\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\namount [old]: 15.1250\r\namount [new]: 151.25\r\ntax_amount [old]: 3.1763\r\ntax_amount [new]: 31.7625\r\ntotal [old]: 18.3013\r\ntotal [new]: 183.0125\r\nlast_modified [old]: 2021-07-20 19:18:29\r\nlast_modified [new]: 2021-07-20 19:27:47\r\n'),
 (110,'2021-07-20 19:28:55','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 1\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 1\r\namount [old]: 151.2500\r\namount [new]: 15.125\r\ntax_amount [old]: 31.7625\r\ntax_amount [new]: 3.17625\r\ntotal [old]: 183.0125\r\ntotal [new]: 18.30125\r\nlast_modified [old]: 2021-07-20 19:27:47\r\nlast_modified [new]: 2021-07-20 19:28:55\r\n'),
 (111,'2021-07-20 19:29:19','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 1\r\n---Fields\r\norders_id [old]: 1\r\nproducts_id [old]: 1\r\nquantity [old]: 1\r\nprice [old]: 15.1250\r\nproduct_price [old]: 15.1250\r\nproduct_tax [old]: 21.00\r\namount [old]: 15.1250\r\ntax_amount [old]: 3.1763\r\ntotal [old]: 18.3013\r\ndate_added [old]: 2021-07-20 18:28:13\r\nlast_modified [old]: 2021-07-20 19:28:55\r\n'),
 (112,'2021-07-20 19:29:29','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 3\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 1\r\namount [old]: 205.2000\r\namount [new]: 20.52\r\ntax_amount [old]: 43.0920\r\ntax_amount [new]: 4.3092\r\ntotal [old]: 248.2920\r\ntotal [new]: 24.8292\r\nlast_modified [old]: 2021-07-20 19:23:11\r\nlast_modified [new]: 2021-07-20 19:29:29\r\n'),
 (113,'2021-07-20 19:39:34','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 3\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\namount [old]: 20.5200\r\namount [new]: 205.2\r\ntax_amount [old]: 4.3092\r\ntax_amount [new]: 43.092\r\ntotal [old]: 24.8292\r\ntotal [new]: 248.292\r\nlast_modified [old]: 2021-07-20 19:29:29\r\nlast_modified [new]: 2021-07-20 19:39:34\r\n'),
 (114,'2021-07-20 19:42:27','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 3\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 1\r\namount [old]: 205.2000\r\namount [new]: 20.52\r\ntax_amount [old]: 43.0920\r\ntax_amount [new]: 4.3092\r\ntotal [old]: 248.2920\r\ntotal [new]: 24.8292\r\nlast_modified [old]: 2021-07-20 19:39:34\r\nlast_modified [new]: 2021-07-20 19:42:27\r\n'),
 (115,'2021-07-20 19:43:22','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 3\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 2\r\namount [old]: 20.5200\r\namount [new]: 41.04\r\ntax_amount [old]: 4.3092\r\ntax_amount [new]: 8.6184\r\ntotal [old]: 24.8292\r\ntotal [new]: 49.6584\r\nlast_modified [old]: 2021-07-20 19:42:27\r\nlast_modified [new]: 2021-07-20 19:43:22\r\n'),
 (116,'2021-07-20 19:43:43','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 4\r\n---Fields\r\norders_id [new]: 1\r\nproducts_id [new]: 2\r\nquantity [new]: 1\r\nprice [new]: 14.25\r\namount [new]: 14.25\r\ntax_amount [new]: 2.9925\r\ntotal [new]: 17.2425\r\ndate_added [new]: 2021-07-20 19:43:43\r\nlast_modified [new]: 2021-07-20 19:43:43\r\n'),
 (117,'2021-07-20 19:46:04','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 4\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\namount [old]: 14.2500\r\namount [new]: 142.5\r\ntax_amount [old]: 2.9925\r\ntax_amount [new]: 29.925\r\ntotal [old]: 17.2425\r\ntotal [new]: 172.425\r\nlast_modified [old]: 2021-07-20 19:43:43\r\nlast_modified [new]: 2021-07-20 19:46:04\r\n'),
 (118,'2021-07-20 19:46:29','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 4\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 1\r\namount [old]: 142.5000\r\namount [new]: 14.25\r\ntax_amount [old]: 29.9250\r\ntax_amount [new]: 2.9925\r\ntotal [old]: 172.4250\r\ntotal [new]: 17.2425\r\nlast_modified [old]: 2021-07-20 19:46:04\r\nlast_modified [new]: 2021-07-20 19:46:29\r\n'),
 (119,'2021-07-20 19:47:43','127.0.0.1','admin','orders','add','---Keys\r\nid_orders : 2\r\n---Fields\r\ncustomers_id [new]: 1\r\norder_status [new]: 0\r\ndate_added [new]: 2021-07-20 19:47:05\r\nlast_modified [new]: 2021-07-20 19:47:05\r\nproduct_count [new]: 0\r\n'),
 (120,'2021-07-20 19:47:43','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 5\r\n---Fields\r\norders_id [new]: 2\r\nproducts_id [new]: 3\r\nquantity [new]: 1\r\nprice [new]: 20.52\r\namount [new]: 20.52\r\ntax_amount [new]: 4.3092\r\ntotal [new]: 24.8292\r\ndate_added [new]: 2021-07-20 19:47:43\r\nlast_modified [new]: 2021-07-20 19:47:43\r\n'),
 (121,'2021-07-20 19:47:44','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 6\r\n---Fields\r\norders_id [new]: 2\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 15.125\r\namount [new]: 15.125\r\ntax_amount [new]: 3.17625\r\ntotal [new]: 18.30125\r\ndate_added [new]: 2021-07-20 19:47:44\r\nlast_modified [new]: 2021-07-20 19:47:44\r\n'),
 (122,'2021-07-20 19:49:22','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 1\r\n---Fields\r\ncustomers_id [old]: 1\r\norder_status [old]: 0\r\ndate_added [old]: 2021-07-20 18:26:41\r\nlast_modified [old]: 2021-07-20 19:08:16\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 183.0125\r\n'),
 (123,'2021-07-20 19:49:22','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 2\r\n---Fields\r\ncustomers_id [old]: 1\r\norder_status [old]: 0\r\ndate_added [old]: 2021-07-20 19:47:05\r\nlast_modified [old]: 2021-07-20 19:47:05\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (124,'2021-07-20 19:58:41','127.0.0.1','admin','orders','add','---Keys\r\nid_orders : 3\r\n---Fields\r\ncustomers_id [new]: 1\r\norder_status [new]: 0\r\ndate_added [new]: 2021-07-20 19:58:01\r\nlast_modified [new]: 2021-07-20 19:58:01\r\nproduct_count [new]: 2\r\namount_total [new]: 29.375\r\ntotal_total [new]: 35.5437\r\ntax_total [new]: 6.1688\r\n'),
 (125,'2021-07-20 19:58:41','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 7\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 2\r\nquantity [new]: 1\r\nprice [new]: 14.25\r\namount [new]: 14.25\r\ntax_amount [new]: 2.9925\r\ntotal [new]: 17.2425\r\ndate_added [new]: 2021-07-20 19:58:41\r\nlast_modified [new]: 2021-07-20 19:58:41\r\n'),
 (126,'2021-07-20 19:58:41','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 8\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 15.125\r\namount [new]: 15.125\r\ntax_amount [new]: 3.1763\r\ntotal [new]: 18.3012\r\ndate_added [new]: 2021-07-20 19:58:41\r\nlast_modified [new]: 2021-07-20 19:58:41\r\n'),
 (127,'2021-07-20 20:02:53','127.0.0.1','admin','users','logout',''),
 (128,'2021-07-21 20:05:38','127.0.0.1','admin','users','login',''),
 (129,'2021-07-22 12:41:28','127.0.0.1','admin','orders','add','---Keys\r\nid_orders : 4\r\n---Fields\r\ncustomers_id [new]: 1\r\norder_status [new]: 0\r\ndate_added [new]: 2021-07-22 12:41:11\r\nlast_modified [new]: 2021-07-22 12:41:11\r\nproduct_count [new]: 1\r\namount_total [new]: 142.5\r\ntotal_total [new]: 172.425\r\ntax_total [new]: 29.925\r\n'),
 (130,'2021-07-22 12:41:29','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 9\r\n---Fields\r\norders_id [new]: 4\r\nproducts_id [new]: 2\r\nquantity [new]: 10\r\nprice [new]: 14.25\r\namount [new]: 142.5\r\ntax_amount [new]: 29.925\r\ntotal [new]: 172.425\r\ndate_added [new]: 2021-07-22 12:41:29\r\nlast_modified [new]: 2021-07-22 12:41:29\r\n'),
 (131,'2021-07-22 12:47:44','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 9\r\n---Fields\r\norders_id [old]: 4\r\nproducts_id [old]: 2\r\nquantity [old]: 10\r\nprice [old]: 14.2500\r\nproduct_price [old]: 14.2500\r\nproduct_tax [old]: 21.00\r\namount [old]: 142.5000\r\ntax_amount [old]: 29.9250\r\ntotal [old]: 172.4250\r\ndate_added [old]: 2021-07-22 12:41:29\r\nlast_modified [old]: 2021-07-22 12:41:29\r\n'),
 (132,'2021-07-22 12:48:26','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 10\r\n---Fields\r\norders_id [new]: 4\r\nproducts_id [new]: 2\r\nquantity [new]: 10\r\nprice [new]: 14.25\r\namount [new]: 142.5\r\ntax_amount [new]: 29.925\r\ntotal [new]: 172.425\r\ndate_added [new]: 2021-07-22 12:48:26\r\nlast_modified [new]: 2021-07-22 12:48:26\r\n'),
 (133,'2021-07-22 12:48:43','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 10\r\n---Fields\r\norders_id [old]: 4\r\nproducts_id [old]: 2\r\nquantity [old]: 10\r\nprice [old]: 14.2500\r\nproduct_price [old]: 14.2500\r\nproduct_tax [old]: 21.00\r\namount [old]: 142.5000\r\ntax_amount [old]: 29.9250\r\ntotal [old]: 172.4250\r\ndate_added [old]: 2021-07-22 12:48:26\r\nlast_modified [old]: 2021-07-22 12:48:26\r\n'),
 (134,'2021-07-22 12:50:03','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 11\r\n---Fields\r\norders_id [new]: 4\r\nproducts_id [new]: 2\r\nquantity [new]: 1\r\nprice [new]: 14.25\r\namount [new]: 14.25\r\ntax_amount [new]: 2.9925\r\ntotal [new]: 17.2425\r\ndate_added [new]: 2021-07-22 12:50:03\r\nlast_modified [new]: 2021-07-22 12:50:03\r\n'),
 (135,'2021-07-22 12:50:03','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 4\r\n---Fields\r\nlast_modified [old]: 2021-07-22 12:41:11\r\nlast_modified [new]: 2021-07-22 12:48:43\r\namount_total [old]: 142.5000\r\namount_total [new]: 14.25\r\ntotal_total [old]: 172.4250\r\ntotal_total [new]: 17.2425\r\ntax_total [old]: 29.9250\r\ntax_total [new]: 2.9925\r\n'),
 (136,'2021-07-22 12:50:16','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 11\r\n---Fields\r\norders_id [old]: 4\r\nproducts_id [old]: 2\r\nquantity [old]: 1\r\nprice [old]: 14.2500\r\nproduct_price [old]: 14.2500\r\nproduct_tax [old]: 21.00\r\namount [old]: 14.2500\r\ntax_amount [old]: 2.9925\r\ntotal [old]: 17.2425\r\ndate_added [old]: 2021-07-22 12:50:03\r\nlast_modified [old]: 2021-07-22 12:50:03\r\n'),
 (137,'2021-07-22 12:51:10','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 12\r\n---Fields\r\norders_id [new]: 4\r\nproducts_id [new]: 2\r\nquantity [new]: 1\r\nprice [new]: 14.25\r\namount [new]: 14.25\r\ntax_amount [new]: 2.9925\r\ntotal [new]: 17.2425\r\ndate_added [new]: 2021-07-22 12:51:10\r\nlast_modified [new]: 2021-07-22 12:51:10\r\n'),
 (138,'2021-07-22 12:51:22','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 12\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\nlast_modified [old]: 2021-07-22 12:51:10\r\nlast_modified [new]: 2021-07-22 12:51:22\r\n'),
 (139,'2021-07-22 12:51:40','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 12\r\n---Fields\r\norders_id [old]: 4\r\nproducts_id [old]: 2\r\nquantity [old]: 10\r\nprice [old]: 14.2500\r\nproduct_price [old]: 14.2500\r\nproduct_tax [old]: 21.00\r\namount [old]: 14.2500\r\ntax_amount [old]: 2.9925\r\ntotal [old]: 17.2425\r\ndate_added [old]: 2021-07-22 12:51:10\r\nlast_modified [old]: 2021-07-22 12:51:22\r\n'),
 (140,'2021-07-22 12:52:44','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 4\r\n---Fields\r\ncustomers_id [old]: 1\r\norder_status [old]: 0\r\ndate_added [old]: 2021-07-22 12:41:11\r\nlast_modified [old]: 2021-07-22 12:48:43\r\nproduct_count [old]: 1\r\namount_total [old]: 14.2500\r\ntax_total [old]: 2.9925\r\ntotal_total [old]: 17.2425\r\n'),
 (141,'2021-07-22 12:54:32','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 8\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\namount [old]: 15.1250\r\namount [new]: 151.25\r\ntax_amount [old]: 3.1763\r\ntax_amount [new]: 31.7625\r\ntotal [old]: 18.3012\r\ntotal [new]: 183.0125\r\nlast_modified [old]: 2021-07-20 19:58:41\r\nlast_modified [new]: 2021-07-22 12:54:32\r\n'),
 (142,'2021-07-22 12:55:44','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 8\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 5\r\namount [old]: 151.2500\r\namount [new]: 75.625\r\ntax_amount [old]: 31.7625\r\ntax_amount [new]: 15.8812\r\ntotal [old]: 183.0125\r\ntotal [new]: 91.5062\r\nlast_modified [old]: 2021-07-22 12:54:32\r\nlast_modified [new]: 2021-07-22 12:55:44\r\n'),
 (143,'2021-07-22 12:56:03','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-20 19:58:01\r\nlast_modified [new]: 2021-07-22 12:55:32\r\n'),
 (144,'2021-07-22 12:56:52','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-22 12:55:32\r\nlast_modified [new]: 2021-07-22 12:56:46\r\n'),
 (145,'2021-07-22 13:00:18','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 8\r\n---Fields\r\norders_id [old]: 3\r\nproducts_id [old]: 1\r\nquantity [old]: 5\r\nprice [old]: 15.1250\r\nproduct_price [old]: 15.1250\r\nproduct_tax [old]: 21.00\r\namount [old]: 75.6250\r\ntax_amount [old]: 15.8812\r\ntotal [old]: 91.5062\r\ndate_added [old]: 2021-07-20 19:58:41\r\nlast_modified [old]: 2021-07-22 12:55:44\r\n'),
 (146,'2021-07-22 13:00:32','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 13\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 15.125\r\namount [new]: 15.125\r\ntax_amount [new]: 3.1763\r\ntotal [new]: 18.3012\r\ndate_added [new]: 2021-07-22 13:00:32\r\nlast_modified [new]: 2021-07-22 13:00:32\r\n'),
 (147,'2021-07-22 13:00:39','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-22 12:56:46\r\nlast_modified [new]: 2021-07-22 13:00:18\r\n'),
 (148,'2021-07-22 13:00:53','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 13\r\n---Fields\r\norders_id [old]: 3\r\nproducts_id [old]: 1\r\nquantity [old]: 1\r\nprice [old]: 15.1250\r\nproduct_price [old]: 15.1250\r\nproduct_tax [old]: 21.00\r\namount [old]: 15.1250\r\ntax_amount [old]: 3.1763\r\ntotal [old]: 18.3012\r\ndate_added [old]: 2021-07-22 13:00:32\r\nlast_modified [old]: 2021-07-22 13:00:32\r\n'),
 (149,'2021-07-22 13:01:22','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-22 13:00:18\r\nlast_modified [new]: 2021-07-22 13:00:54\r\n'),
 (150,'2021-07-22 13:32:03','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-22 13:00:54\r\nlast_modified [new]: 2021-07-22 13:32:00\r\n'),
 (151,'2021-07-22 13:34:23','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 7\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 10\r\namount [old]: 14.2500\r\namount [new]: 142.5\r\ntax_amount [old]: 2.9925\r\ntax_amount [new]: 29.925\r\ntotal [old]: 17.2425\r\ntotal [new]: 172.425\r\nlast_modified [old]: 2021-07-20 19:58:41\r\nlast_modified [new]: 2021-07-22 13:34:23\r\n'),
 (152,'2021-07-22 13:35:15','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 7\r\n---Fields\r\nquantity [old]: 10\r\nquantity [new]: 1\r\namount [old]: 142.5000\r\namount [new]: 14.25\r\ntax_amount [old]: 29.9250\r\ntax_amount [new]: 2.9925\r\ntotal [old]: 172.4250\r\ntotal [new]: 17.2425\r\nlast_modified [old]: 2021-07-22 13:34:23\r\nlast_modified [new]: 2021-07-22 13:35:15\r\n'),
 (153,'2021-07-22 13:39:06','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 7\r\n---Fields\r\nquantity [old]: 1\r\nquantity [new]: 20\r\namount [old]: 14.2500\r\namount [new]: 285\r\ntax_amount [old]: 2.9925\r\ntax_amount [new]: 59.85\r\ntotal [old]: 17.2425\r\ntotal [new]: 344.85\r\nlast_modified [old]: 2021-07-22 13:35:15\r\nlast_modified [new]: 2021-07-22 13:39:06\r\n'),
 (154,'2021-07-22 13:39:39','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 7\r\n---Fields\r\nproducts_id [old]: 2\r\nproducts_id [new]: 3\r\nlast_modified [old]: 2021-07-22 13:39:06\r\nlast_modified [new]: 2021-07-22 13:39:39\r\n'),
 (155,'2021-07-22 13:43:35','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 7\r\n---Fields\r\nquantity [old]: 20\r\nquantity [new]: 1\r\nprice [old]: 14.2500\r\nprice [new]: 20.52\r\namount [old]: 285.0000\r\namount [new]: 20.52\r\ntax_amount [old]: 59.8500\r\ntax_amount [new]: 4.3092\r\ntotal [old]: 344.8500\r\ntotal [new]: 24.8292\r\nlast_modified [old]: 2021-07-22 13:39:39\r\nlast_modified [new]: 2021-07-22 13:43:35\r\n'),
 (156,'2021-07-22 13:50:05','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 7\r\n---Fields\r\nproducts_id [old]: 3\r\nproducts_id [new]: 2\r\nquantity [old]: 1\r\nquantity [new]: 2\r\nprice [old]: 20.5200\r\nprice [new]: 14.25\r\namount [old]: 20.5200\r\namount [new]: 28.5\r\ntax_amount [old]: 4.3092\r\ntax_amount [new]: 5.985\r\ntotal [old]: 24.8292\r\ntotal [new]: 34.485\r\nlast_modified [old]: 2021-07-22 13:43:35\r\nlast_modified [new]: 2021-07-22 13:50:05\r\n'),
 (157,'2021-07-22 13:54:48','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 7\r\n---Fields\r\nquantity [old]: 2\r\nquantity [new]: 1\r\namount [old]: 28.5000\r\namount [new]: 14.25\r\ntax_amount [old]: 5.9850\r\ntax_amount [new]: 2.9925\r\ntotal [old]: 34.4850\r\ntotal [new]: 17.2425\r\nlast_modified [old]: 2021-07-22 13:50:05\r\nlast_modified [new]: 2021-07-22 13:54:48\r\n'),
 (158,'2021-07-22 13:58:03','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 14\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 3\r\nquantity [new]: 1\r\nprice [new]: 20.52\r\namount [new]: 20.52\r\ntax_amount [new]: 4.3092\r\ntotal [new]: 24.8292\r\ndate_added [new]: 2021-07-22 13:58:03\r\nlast_modified [new]: 2021-07-22 13:58:03\r\n'),
 (159,'2021-07-22 14:01:57','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 14\r\n---Fields\r\nproducts_id [old]: 3\r\nproducts_id [new]: 2\r\nlast_modified [old]: 2021-07-22 13:58:03\r\nlast_modified [new]: 2021-07-22 14:01:57\r\n'),
 (160,'2021-07-22 14:08:26','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 14\r\n---Fields\r\nproducts_id [old]: 2\r\nproducts_id [new]: 3\r\nlast_modified [old]: 2021-07-22 14:01:57\r\nlast_modified [new]: 2021-07-22 14:08:26\r\n'),
 (161,'2021-07-22 14:08:55','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 16\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 2\r\nquantity [new]: 1\r\nprice [new]: 14.25\r\namount [new]: 14.25\r\ntax_amount [new]: 2.9925\r\ntotal [new]: 17.2425\r\ndate_added [new]: 2021-07-22 14:08:55\r\nlast_modified [new]: 2021-07-22 14:08:55\r\n'),
 (162,'2021-07-22 18:36:18','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 16\r\n---Fields\r\norders_id [old]: 3\r\nproducts_id [old]: 2\r\nquantity [old]: 1\r\nprice [old]: 14.2500\r\nproduct_price [old]: 14.2500\r\nproduct_tax [old]: 21.00\r\namount [old]: 14.2500\r\ntax_amount [old]: 2.9925\r\ntotal [old]: 17.2425\r\ndate_added [old]: 2021-07-22 14:08:55\r\nlast_modified [old]: 2021-07-22 14:08:55\r\n'),
 (163,'2021-07-22 18:36:39','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 18\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 15.125\r\namount [new]: 15.125\r\ntax_amount [new]: 3.1763\r\ntotal [new]: 18.3012\r\ndate_added [new]: 2021-07-22 18:36:39\r\nlast_modified [new]: 2021-07-22 18:36:39\r\n'),
 (164,'2021-07-22 18:40:06','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 20\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 1\r\nquantity [new]: 10\r\nprice [new]: 15.125\r\namount [new]: 151.25\r\ntax_amount [new]: 31.7625\r\ntotal [new]: 183.0125\r\ndate_added [new]: 2021-07-22 18:40:06\r\nlast_modified [new]: 2021-07-22 18:40:06\r\n'),
 (165,'2021-07-22 18:43:02','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 20\r\n---Fields\r\norders_id [old]: 3\r\nproducts_id [old]: 1\r\nquantity [old]: 10\r\nprice [old]: 15.1250\r\nproduct_price [old]: 15.1250\r\nproduct_tax [old]: 21.00\r\namount [old]: 151.2500\r\ntax_amount [old]: 31.7625\r\ntotal [old]: 183.0125\r\ndate_added [old]: 2021-07-22 18:40:06\r\nlast_modified [old]: 2021-07-22 18:40:06\r\n'),
 (166,'2021-07-22 18:43:25','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 21\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 3\r\nquantity [new]: 1\r\nprice [new]: 20.52\r\namount [new]: 20.52\r\ntax_amount [new]: 4.3092\r\ntotal [new]: 24.8292\r\ndate_added [new]: 2021-07-22 18:43:25\r\nlast_modified [new]: 2021-07-22 18:43:25\r\n'),
 (167,'2021-07-22 18:44:01','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-22 13:32:00\r\nlast_modified [new]: 2021-07-22 18:43:25\r\n'),
 (168,'2021-07-22 19:09:03','127.0.0.1','admin','orders','add','---Keys\r\nid_orders : 5\r\n---Fields\r\ncustomers_id [new]: 1\r\norder_status [new]: 0\r\ndate_added [new]: 2021-07-22 19:08:05\r\nlast_modified [new]: 2021-07-22 19:08:05\r\nproduct_count [new]: 1\r\namount_total [new]: 15.125\r\ntotal_total [new]: 18.3012\r\ntax_total [new]: 3.1763\r\n'),
 (169,'2021-07-22 19:09:03','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 22\r\n---Fields\r\norders_id [new]: 5\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 15.125\r\namount [new]: 15.125\r\ntax_amount [new]: 3.1763\r\ntotal [new]: 18.3012\r\ndate_added [new]: 2021-07-22 19:09:03\r\nlast_modified [new]: 2021-07-22 19:09:03\r\n'),
 (170,'2021-07-22 19:09:55','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 23\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 1\r\nquantity [new]: 10\r\nprice [new]: 15.125\r\namount [new]: 151.25\r\ntax_amount [new]: 31.7625\r\ntotal [new]: 183.0125\r\ndate_added [new]: 2021-07-22 19:09:55\r\nlast_modified [new]: 2021-07-22 19:09:55\r\n'),
 (171,'2021-07-22 19:10:03','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-22 18:43:25\r\nlast_modified [new]: 2021-07-22 19:09:55\r\n'),
 (172,'2021-07-22 19:10:17','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 23\r\n---Fields\r\norders_id [old]: 3\r\nproducts_id [old]: 1\r\nquantity [old]: 10\r\nprice [old]: 15.1250\r\nproduct_price [old]: 15.1250\r\nproduct_tax [old]: 21.00\r\namount [old]: 151.2500\r\ntax_amount [old]: 31.7625\r\ntotal [old]: 183.0125\r\ndate_added [old]: 2021-07-22 19:09:55\r\nlast_modified [old]: 2021-07-22 19:09:55\r\n'),
 (173,'2021-07-22 19:11:01','127.0.0.1','admin','orders_products','edit','---Keys\r\nid_orders_products : 21\r\n---Fields\r\nproducts_id [old]: 3\r\nproducts_id [new]: 1\r\nquantity [old]: 1\r\nquantity [new]: 10\r\nprice [old]: 20.5200\r\nprice [new]: 15.125\r\namount [old]: 20.5200\r\namount [new]: 151.25\r\ntax_amount [old]: 4.3092\r\ntax_amount [new]: 31.7625\r\ntotal [old]: 24.8292\r\ntotal [new]: 183.0125\r\nlast_modified [old]: 2021-07-22 18:43:25\r\nlast_modified [new]: 2021-07-22 19:11:01\r\n'),
 (174,'2021-07-22 19:11:34','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 21\r\n---Fields\r\norders_id [old]: 3\r\nproducts_id [old]: 1\r\nquantity [old]: 10\r\nprice [old]: 15.1250\r\nproduct_price [old]: 15.1250\r\nproduct_tax [old]: 21.00\r\namount [old]: 151.2500\r\ntax_amount [old]: 31.7625\r\ntotal [old]: 183.0125\r\ndate_added [old]: 2021-07-22 18:43:25\r\nlast_modified [old]: 2021-07-22 19:11:01\r\n'),
 (175,'2021-07-22 19:11:43','127.0.0.1','admin','orders_products','delete','---Keys\r\nid_orders_products : 18\r\n---Fields\r\norders_id [old]: 3\r\nproducts_id [old]: 1\r\nquantity [old]: 1\r\nprice [old]: 15.1250\r\nproduct_price [old]: 15.1250\r\nproduct_tax [old]: 21.00\r\namount [old]: 15.1250\r\ntax_amount [old]: 3.1763\r\ntotal [old]: 18.3012\r\ndate_added [old]: 2021-07-22 18:36:39\r\nlast_modified [old]: 2021-07-22 18:36:39\r\n'),
 (176,'2021-07-22 19:11:55','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 24\r\n---Fields\r\norders_id [new]: 3\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 15.125\r\namount [new]: 15.125\r\ntax_amount [new]: 3.1763\r\ntotal [new]: 18.3012\r\ndate_added [new]: 2021-07-22 19:11:55\r\nlast_modified [new]: 2021-07-22 19:11:55\r\n'),
 (177,'2021-07-22 19:11:55','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-22 19:09:55\r\nlast_modified [new]: 2021-07-22 19:11:43\r\nproduct_count [old]: 3\r\nproduct_count [new]: 2\r\namount_total [old]: 49.8950\r\namount_total [new]: 34.77\r\ntotal_total [old]: 60.3729\r\ntotal_total [new]: 42.0717\r\ntax_total [old]: 10.4780\r\ntax_total [new]: 7.3017\r\n'),
 (178,'2021-07-23 12:19:02','127.0.0.1','admin','users','login',''),
 (179,'2021-07-23 19:05:35','127.0.0.1','admin','users','logout',''),
 (180,'2021-07-23 19:05:43','127.0.0.1','admin','users','login',''),
 (181,'2021-07-23 19:07:31','127.0.0.1','admin','users','logout',''),
 (182,'2021-07-23 19:07:34','127.0.0.1','admin','users','login',''),
 (183,'2021-07-23 19:54:31','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 2\r\n---Fields\r\ndelivery_status [old]: 0\r\ndelivery_status [new]: 1\r\nlast_modified [old]: 2021-07-20 17:23:21\r\nlast_modified [new]: 2021-07-23 19:54:22\r\n'),
 (184,'2021-07-24 19:35:50','127.0.0.1','admin','users','logout',''),
 (185,'2021-07-24 19:35:53','127.0.0.1','admin','users','login',''),
 (186,'2021-07-24 20:19:32','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 2\r\n---Fields\r\ndelivery_status [old]: 1\r\ndelivery_status [new]: 2\r\nlast_modified [old]: 2021-07-23 19:54:22\r\nlast_modified [new]: 2021-07-24 20:19:25\r\n'),
 (187,'2021-07-24 20:19:42','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 2\r\n---Fields\r\ndelivery_status [old]: 2\r\ndelivery_status [new]: 3\r\nlast_modified [old]: 2021-07-24 20:19:25\r\nlast_modified [new]: 2021-07-24 20:19:33\r\n'),
 (188,'2021-07-24 20:59:04','127.0.0.1','admin','delivery_note','add','---Keys\r\nid_delivery_note : 4\r\n---Fields\r\nmanufacturers_id [new]: 2\r\ndelivery_status [new]: 0\r\ndate_added [new]: 2021-07-24 20:57:41\r\nlast_modified [new]: 2021-07-24 20:57:41\r\nproduct_count [new]: 1\r\namount_total [new]: 150\r\ntax_total [new]: 31.5\r\ntotal_total [new]: 181.5\r\n'),
 (189,'2021-07-24 20:59:04','127.0.0.1','admin','delivery_products','add','---Keys\r\nid_delivery_products : 4\r\n---Fields\r\nproducts_id [new]: 2\r\nquantity [new]: 10\r\nprice [new]: 15\r\namount [new]: 150\r\ntax_amount [new]: 31.5\r\ntotal [new]: 181.5\r\ndelivery_note_id [new]: 4\r\ndate_added [new]: 2021-07-24 20:59:04\r\nlast_modified [new]: 2021-07-24 20:59:04\r\n'),
 (190,'2021-07-25 14:25:11','127.0.0.1','admin','delivery_products','add','---Keys\r\nid_delivery_products : 5\r\n---Fields\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 14\r\namount [new]: 14\r\ntax_amount [new]: 2.94\r\ntotal [new]: 16.94\r\ndelivery_note_id [new]: 3\r\ndate_added [new]: 2021-07-25 14:25:11\r\nlast_modified [new]: 2021-07-25 14:25:11\r\n'),
 (191,'2021-07-25 14:25:12','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 3\r\n---Fields\r\nlast_modified [old]: 2021-07-20 13:37:46\r\nlast_modified [new]: 2021-07-25 14:24:44\r\n'),
 (192,'2021-07-25 18:25:55','127.0.0.1','admin','manufacturers','edit','---Keys\r\nid_manufacturers : 2\r\n---Fields\r\nmanufacturer_name [old]: Bodegas Protos\r\nmanufacturer_name [new]: Bodegas Protos, S.A.\r\n'),
 (193,'2021-07-25 18:26:07','127.0.0.1','admin','manufacturers','edit','---Keys\r\nid_manufacturers : 1\r\n---Fields\r\nmanufacturer_name [old]: Bodegas Pesquera\r\nmanufacturer_name [new]: Bodegas Pesquera, S.L.\r\n'),
 (194,'2021-07-25 18:38:46','127.0.0.1','admin','delivery_note','add','---Keys\r\nid_delivery_note : 5\r\n---Fields\r\nmanufacturers_id [new]: 1\r\ndelivery_status [new]: 0\r\ndate_added [new]: 2021-07-25 18:37:49\r\nlast_modified [new]: 2021-07-25 18:37:49\r\nproduct_count [new]: 2\r\n'),
 (195,'2021-07-25 18:38:46','127.0.0.1','admin','delivery_products','add','---Keys\r\nid_delivery_products : 6\r\n---Fields\r\nproducts_id [new]: 1\r\nquantity [new]: 10\r\nprice [new]: 14\r\namount [new]: 140\r\ntax_amount [new]: 29.4\r\ntotal [new]: 169.4\r\ndelivery_note_id [new]: 5\r\ndate_added [new]: 2021-07-25 18:38:46\r\nlast_modified [new]: 2021-07-25 18:38:46\r\n'),
 (196,'2021-07-25 18:38:47','127.0.0.1','admin','delivery_products','add','---Keys\r\nid_delivery_products : 7\r\n---Fields\r\nproducts_id [new]: 3\r\nquantity [new]: 10\r\nprice [new]: 18\r\namount [new]: 180\r\ntax_amount [new]: 37.8\r\ntotal [new]: 217.8\r\ndelivery_note_id [new]: 5\r\ndate_added [new]: 2021-07-25 18:38:47\r\nlast_modified [new]: 2021-07-25 18:38:47\r\n'),
 (197,'2021-07-25 18:39:17','127.0.0.1','admin','delivery_note','edit','---Keys\r\nid_delivery_note : 5\r\n---Fields\r\nlast_modified [old]: 2021-07-25 18:37:49\r\nlast_modified [new]: 2021-07-25 18:38:47\r\namount_total [old]: 0.0000\r\namount_total [new]: 320\r\ndiscounts_total [old]: 0.0000\r\ndiscounts_total [new]: 3\r\ntax_total [old]: 0.0000\r\ntax_total [new]: 67.2\r\ntotal_total [old]: 0.0000\r\ntotal_total [new]: 384.2\r\n'),
 (198,'2021-07-25 18:46:36','127.0.0.1','admin','orders','add','---Keys\r\nid_orders : 6\r\n---Fields\r\ncustomers_id [new]: 1\r\norder_status [new]: 0\r\ndate_added [new]: 2021-07-25 18:46:17\r\nlast_modified [new]: 2021-07-25 18:46:17\r\nproduct_count [new]: 1\r\namount_total [new]: 15.125\r\ntotal_total [new]: 18.3012\r\ntax_total [new]: 3.1763\r\n'),
 (199,'2021-07-25 18:46:36','127.0.0.1','admin','orders_products','add','---Keys\r\nid_orders_products : 25\r\n---Fields\r\nproducts_id [new]: 1\r\nquantity [new]: 1\r\nprice [new]: 15.125\r\namount [new]: 15.125\r\ntax_amount [new]: 3.1763\r\ntotal [new]: 18.3012\r\norders_id [new]: 6\r\ndate_added [new]: 2021-07-25 18:46:36\r\nlast_modified [new]: 2021-07-25 18:46:36\r\n'),
 (200,'2021-07-25 18:56:47','127.0.0.1','admin','users','logout',''),
 (201,'2021-08-11 13:17:23','127.0.0.1','admin','users','login',''),
 (202,'2021-08-11 20:10:35','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 32\r\n---Fields\r\nlanguage [old]: \r\nlanguage [new]: Spanish\r\n'),
 (203,'2021-08-11 20:56:47','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\nquantity [old]: 0\r\nquantity [new]: 1\r\nlast_modified [old]: 2021-07-20 17:30:00\r\nlast_modified [new]: 2021-08-11 20:56:34\r\n'),
 (205,'2021-08-11 20:58:52','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\norder_status [old]: 1\r\norder_status [new]: 2\r\nlast_modified [old]: 2021-07-22 19:11:43\r\nlast_modified [new]: 2021-08-11 20:58:27\r\n'),
 (206,'2021-08-11 21:08:12','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 2\r\n---Fields\r\nlast_modified [old]: 2021-07-20 17:18:23\r\nlast_modified [new]: 2021-08-11 21:08:09\r\n'),
 (207,'2021-08-11 21:08:23','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\nquantity [old]: 0\r\nquantity [new]: 1\r\nlast_modified [old]: 2021-08-11 20:56:34\r\nlast_modified [new]: 2021-08-11 21:08:18\r\n'),
 (208,'2021-08-11 21:16:07','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\norder_status [old]: 2\r\norder_status [new]: 3\r\nlast_modified [old]: 2021-08-11 20:58:27\r\nlast_modified [new]: 2021-08-11 21:15:50\r\n'),
 (209,'2021-08-11 21:16:26','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\norder_status [old]: 3\r\norder_status [new]: 4\r\nlast_modified [old]: 2021-08-11 21:15:50\r\nlast_modified [new]: 2021-08-11 21:16:07\r\n'),
 (210,'2021-08-11 21:16:37','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\norder_status [old]: 4\r\norder_status [new]: 5\r\nlast_modified [old]: 2021-08-11 21:16:07\r\nlast_modified [new]: 2021-08-11 21:16:27\r\n'),
 (211,'2021-08-11 21:16:45','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\norder_status [old]: 5\r\norder_status [new]: 6\r\nlast_modified [old]: 2021-08-11 21:16:27\r\nlast_modified [new]: 2021-08-11 21:16:38\r\n'),
 (212,'2021-08-11 21:17:09','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\norder_status [old]: 6\r\norder_status [new]: 7\r\nlast_modified [old]: 2021-08-11 21:16:38\r\nlast_modified [new]: 2021-08-11 21:16:46\r\n'),
 (213,'2021-08-12 12:53:00','127.0.0.1','admin','orders','edit','---Keys\r\nid_orders : 3\r\n---Fields\r\norder_status [old]: 7\r\norder_status [new]: 8\r\nlast_modified [old]: 2021-08-11 21:16:46\r\nlast_modified [new]: 2021-08-12 12:52:25\r\n'),
 (214,'2021-08-12 12:57:38','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 22\r\n---Fields\r\ncatalog_code [old]: Rivera Region\r\ncatalog_code [new]: Ribera Region\r\n'),
 (215,'2021-08-13 11:45:57','127.0.0.1','admin','users','logout',''),
 (216,'2021-08-13 11:46:05','127.0.0.1','admin','users','login',''),
 (217,'2021-08-15 12:53:19','127.0.0.1','admin','users','login',''),
 (218,'2021-08-15 12:53:45','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nlast_modified [old]: 2021-07-20 17:28:33\r\nlast_modified [new]: 2021-08-15 12:53:36\r\nisVisible [old]: 0\r\nisVisible [new]: 1\r\n'),
 (219,'2021-08-15 12:53:53','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 2\r\n---Fields\r\nlast_modified [old]: 2021-08-11 21:08:09\r\nlast_modified [new]: 2021-08-15 12:53:48\r\nisVisible [old]: 0\r\nisVisible [new]: 1\r\n'),
 (220,'2021-08-15 12:53:59','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\nlast_modified [old]: 2021-08-11 21:08:18\r\nlast_modified [new]: 2021-08-15 12:53:55\r\nisVisible [old]: 0\r\nisVisible [new]: 1\r\n'),
 (221,'2021-08-15 17:58:44','127.0.0.1','admin','type_master','edit','---Keys\r\nid_catalog : 3\r\n---Fields\r\ncatalog_code [old]: Vinos\r\ncatalog_code [new]: Vinos ......................................................\r\n'),
 (222,'2021-08-15 17:59:36','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 5\r\n---Fields\r\ncatalog_code [old]: Región Rioja\r\ncatalog_code [new]: Región Rioja ...............................................\r\n'),
 (223,'2021-08-15 17:59:58','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 5\r\n---Fields\r\ncatalog_code [old]: Región Rioja ...............................................\r\ncatalog_code [new]: Región Rioja\r\n'),
 (224,'2021-08-15 18:00:13','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 21\r\n---Fields\r\ncatalog_code [old]: Región Ribera\r\ncatalog_code [new]: Región Ribera ..............................................\r\n'),
 (225,'2021-08-15 18:00:39','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 21\r\n---Fields\r\ncatalog_code [old]: Región Ribera ..............................................\r\ncatalog_code [new]: Región Ribera\r\n'),
 (226,'2021-08-15 18:00:47','127.0.0.1','admin','type_master','edit','---Keys\r\nid_catalog : 3\r\n---Fields\r\ncatalog_code [old]: Vinos ......................................................\r\ncatalog_code [new]: Vinos\r\n');
INSERT INTO `ecommerce_priv_audit` (`id`,`datetime`,`ip`,`user`,`table`,`action`,`description`) VALUES 
 (227,'2021-08-15 18:48:03','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nimages [old]: \r\nimages [new]: [{\"name\":\"files\\/vino_001_6reynn5g.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"files\\/thvino_001_g6pwh3tc.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-15 12:53:36\r\nlast_modified [new]: 2021-08-15 18:47:40\r\n'),
 (228,'2021-08-15 19:20:41','127.0.0.1','admin','users','login',''),
 (229,'2021-08-15 19:21:04','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nimages [old]: [{\"name\":\"files\\/vino_001_6reynn5g.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"files\\/thvino_001_g6pwh3tc.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nimages [new]: \r\nlast_modified [old]: 2021-08-15 18:47:40\r\nlast_modified [new]: 2021-08-15 19:21:00\r\n'),
 (230,'2021-08-15 19:23:34','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nimages [old]: \r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_yifn4f2h.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_s2sjdunm.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-15 19:21:00\r\nlast_modified [new]: 2021-08-15 19:23:07\r\n'),
 (231,'2021-08-15 19:30:12','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 2\r\n---Fields\r\nimages [old]: \r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_sm7dk05h.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_bkvklwza.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-15 12:53:48\r\nlast_modified [new]: 2021-08-15 19:29:58\r\n'),
 (232,'2021-08-15 19:30:28','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\nimages [old]: \r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_cl9vx3d6.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_ptd8ec8w.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-15 12:53:55\r\nlast_modified [new]: 2021-08-15 19:30:16\r\n'),
 (233,'2021-08-16 19:08:57','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: #spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano spanish#  #english Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel english# \r\ndescription [new]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\nlast_modified [old]: 2021-08-15 19:23:07\r\nlast_modified [new]: 2021-08-16 19:08:29\r\n'),
 (234,'2021-08-16 19:09:05','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 2\r\n---Fields\r\ndescription [old]: \r\ndescription [new]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#\r\nlast_modified [old]: 2021-08-15 19:29:58\r\nlast_modified [new]: 2021-08-16 19:09:00\r\n'),
 (235,'2021-08-16 19:09:13','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\ndescription [old]: #spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano spanish#  #english Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel english# \r\ndescription [new]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\nlast_modified [old]: 2021-08-15 19:30:16\r\nlast_modified [new]: 2021-08-16 19:09:07\r\n'),
 (236,'2021-08-16 19:09:55','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\ndescription [old]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\ndescription [new]: #Spanish Vino con al menos 5 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 5 years of aging, with fruity flavor and cured in American oak barrel English# \r\nlast_modified [old]: 2021-08-16 19:09:07\r\nlast_modified [new]: 2021-08-16 19:09:44\r\n'),
 (237,'2021-08-16 19:35:04','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nmodel [old]: Pesquera crianza\r\nmodel [new]: Pesquera crianza 2018\r\nlast_modified [old]: 2021-08-16 19:08:29\r\nlast_modified [new]: 2021-08-16 19:34:52\r\n'),
 (238,'2021-08-16 19:35:34','127.0.0.1','admin','products','add','---Keys\r\nid_products : 4\r\n---Fields\r\ntype_num [new]: 1\r\ntax_id [new]: 2\r\nmanufacturers_id [new]: 1\r\nmodel [new]: Pesquera crianza 2019\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_uydrrow6.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_ayvqesrs.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nprice [new]: 15.125\r\ndescription [new]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\nquantity [new]: 10\r\ndate_added [new]: 2021-08-16 19:35:24\r\nlast_modified [new]: 2021-08-16 19:34:52\r\nquantity_order_min [new]: 1\r\nisVisible [new]: 1\r\nmaster_num [new]: 0\r\nisVirtual [new]: 0\r\n'),
 (239,'2021-08-16 19:36:04','127.0.0.1','admin','products','add','---Keys\r\nid_products : 5\r\n---Fields\r\ntype_num [new]: 1\r\ntax_id [new]: 2\r\nmanufacturers_id [new]: 1\r\nmodel [new]: Pesquera crianza 2020\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_jtwsrzd1.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_yk5bg4jd.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nprice [new]: 15.125\r\ndescription [new]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\nquantity [new]: 10\r\ndate_added [new]: 2021-07-15 18:29:07\r\nlast_modified [new]: 2021-08-16 19:34:52\r\nquantity_order_min [new]: 1\r\nisVisible [new]: 1\r\nmaster_num [new]: 0\r\nisVirtual [new]: 0\r\n'),
 (240,'2021-08-16 19:39:32','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\ndescription [new]: Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano   #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\nlast_modified [old]: 2021-08-16 19:34:52\r\nlast_modified [new]: 2021-08-16 19:39:15\r\n'),
 (241,'2021-08-16 19:40:23','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano   #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\ndescription [new]: Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano   Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel  \r\nlast_modified [old]: 2021-08-16 19:39:15\r\nlast_modified [new]: 2021-08-16 19:40:02\r\n'),
 (242,'2021-08-16 19:59:49','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano   Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel  \r\ndescription [new]: <p>%Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish%</p><p>%English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English%</p>\r\nlast_modified [old]: 2021-08-16 19:40:02\r\nlast_modified [new]: 2021-08-16 19:54:31\r\n'),
 (243,'2021-08-16 20:02:45','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 2\r\n---Fields\r\ndescription [old]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#\r\ndescription [new]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>\r\nlast_modified [old]: 2021-08-16 19:09:00\r\nlast_modified [new]: 2021-08-16 20:02:01\r\n'),
 (244,'2021-08-16 20:04:50','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: <p>%Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish%</p><p>%English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English%</p>\r\ndescription [new]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>\r\nlast_modified [old]: 2021-08-16 19:54:31\r\nlast_modified [new]: 2021-08-16 20:04:44\r\n'),
 (245,'2021-08-16 20:05:00','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\ndescription [old]: #Spanish Vino con al menos 5 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 5 years of aging, with fruity flavor and cured in American oak barrel English# \r\ndescription [new]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>\r\nlast_modified [old]: 2021-08-16 19:09:44\r\nlast_modified [new]: 2021-08-16 20:04:54\r\n'),
 (246,'2021-08-16 20:05:14','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 4\r\n---Fields\r\ndescription [old]: #Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#  #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English# \r\ndescription [new]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>\r\nlast_modified [old]: 2021-08-16 19:34:52\r\nlast_modified [new]: 2021-08-16 20:05:07\r\n'),
 (247,'2021-08-16 20:09:12','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>\r\ndescription [new]: <p>#Spanish <br>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.<br></p><p>Especial para carnes rojas,<br>Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>\r\nlast_modified [old]: 2021-08-16 20:04:44\r\nlast_modified [new]: 2021-08-16 20:08:30\r\n'),
 (248,'2021-08-16 20:10:57','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: <p>#Spanish <br>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.<br></p><p>Especial para carnes rojas,<br>Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>\r\ndescription [new]: <p>#Spanish <br>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.<u><em><br></em></u></p><p><u><strong><em><span style=\"color: rgb(192, 80, 77);\"><em>Especia</em>l</span></em></strong></u> para carnes rojas,<br>Spanish# <br></p><p> #English Wine with at \r\nlast_modified [old]: 2021-08-16 20:08:30\r\nlast_modified [new]: 2021-08-16 20:10:08\r\n'),
 (249,'2021-08-16 20:14:03','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: <p>#Spanish <br>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.<u><em><br></em></u></p><p><u><strong><em><span style=\"color: rgb(192, 80, 77);\"><em>Especia</em>l</span></em></strong></u> para carnes rojas,<br>Spanish# <br></p><p> #English Wine with at \r\ndescription [new]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.<u><em><br></em></u></p><p><u><strong><em><span style=\"color: rgb(192, 80, 77);\"><em>Especia</em>l</span></em></strong></u> para carnes rojas,<br>Spanish# <br></p><p> #English Wine with at leas\r\nlast_modified [old]: 2021-08-16 20:10:08\r\nlast_modified [new]: 2021-08-16 20:13:45\r\n'),
 (250,'2021-08-17 12:50:06','127.0.0.1','admin','users','logout',''),
 (251,'2021-08-17 12:50:22','127.0.0.1','admin','users','login',''),
 (252,'2021-08-17 12:50:29','127.0.0.1','admin','users','logout',''),
 (253,'2021-08-18 14:24:01','127.0.0.1','admin','users','login',''),
 (254,'2021-08-18 14:24:50','127.0.0.1','admin','users','login',''),
 (255,'2021-08-18 14:25:36','127.0.0.1','admin','customers','edit','---Keys\r\nid_customers : 1\r\n---Fields\r\npassword [old]: fhumanes\r\npassword [new]: 21232f297a57a5a743894a0e4a801fc3\r\n'),
 (256,'2021-08-19 14:08:42','127.0.0.1','admin','users','login',''),
 (257,'2021-08-19 14:09:20','127.0.0.1','admin','tax','edit','---Keys\r\nid_tax : 2\r\n---Fields\r\ntax_code [old]: General\r\ntax_code [new]: General - 21%\r\n'),
 (258,'2021-08-19 14:09:30','127.0.0.1','admin','tax','edit','---Keys\r\nid_tax : 1\r\n---Fields\r\ntax_code [old]: Reducido\r\ntax_code [new]: Reducido - 10%\r\n'),
 (259,'2021-08-19 18:41:16','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nprice [old]: 15.1250\r\nprice [new]: 1115.125\r\nlast_modified [old]: 2021-08-16 20:13:45\r\nlast_modified [new]: 2021-08-19 18:41:08\r\n'),
 (260,'2021-08-19 18:43:05','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nprice [old]: 1115.1250\r\nprice [new]: 15.125\r\nlast_modified [old]: 2021-08-19 18:41:08\r\nlast_modified [new]: 2021-08-19 18:42:55\r\n'),
 (261,'2021-08-19 20:14:56','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.<u><em><br></em></u></p><p><u><strong><em><span style=\"color: rgb(192, 80, 77);\"><em>Especia</em>l</span></em></strong></u> para carnes rojas,<br>Spanish# <br></p><p> #English Wine with at leas\r\ndescription [new]: #Spanish<p>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.</p>Spanish# #English<p>Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel.</p>English#  <p></p> <ul class=\"nav nav-tabs\">   <li class=\"active\"><a data-togg\r\nlast_modified [old]: 2021-08-19 18:42:55\r\nlast_modified [new]: 2021-08-19 19:54:02\r\n'),
 (262,'2021-08-19 20:34:21','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\ndescription [old]: #Spanish<p>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.</p>Spanish# #English<p>Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel.</p>English#  <p></p> <ul class=\"nav nav-tabs\">   <li class=\"active\"><a data-togg\r\ndescription [new]: #Spanish<p>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.</p>Spanish# #English<p>Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel.</p>English#  <p></p>  #info_Spanish<div> <ul class=\"nav nav-tabs\">   <li class=\"\r\nlast_modified [old]: 2021-08-19 19:54:02\r\nlast_modified [new]: 2021-08-19 20:19:14\r\n'),
 (263,'2021-08-20 12:43:04','127.0.0.1','admin','type_master','add','---Keys\r\nid_catalog : 41\r\n---Fields\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 10\r\ncatalog_code [new]: Electrónica\r\ndescription [new]: Electrónica\r\ncatalog_master_id [new]: 2\r\n'),
 (264,'2021-08-20 12:43:53','127.0.0.1','admin','type_master','add','---Keys\r\nid_catalog : 42\r\n---Fields\r\ncatalog_num [new]: 10\r\ncatalog_code [new]: Electronics\r\ncatalog_master_id [new]: 2\r\n'),
 (265,'2021-08-20 12:44:57','127.0.0.1','admin','type','add','---Keys\r\nid_catalog : 43\r\n---Fields\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Portátiles\r\ngroup_num [new]: 10\r\ncatalog_master_id [new]: 3\r\n'),
 (266,'2021-08-20 12:45:54','127.0.0.1','admin','type_master','edit','---Keys\r\nid_catalog : 42\r\n---Fields\r\nlanguage [old]: \r\nlanguage [new]: English\r\n'),
 (267,'2021-08-20 12:47:23','127.0.0.1','admin','type','add','---Keys\r\nid_catalog : 44\r\n---Fields\r\nlanguage [new]: English\r\ncatalog_num [new]: 0\r\ncatalog_code [new]: Laptops\r\ngroup_num [new]: 10\r\ncatalog_master_id [new]: 3\r\n'),
 (268,'2021-08-20 12:52:31','127.0.0.1','admin','products','add','---Keys\r\nid_products : 6\r\n---Fields\r\nmodel [new]: Cune reserva\r\ndescription [new]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p><p></p>  #info_Spanish    Descripción   Datos Técnicos        \r\nprice [new]: 20.52\r\nquantity [new]: 2\r\nisVirtual [new]: 0\r\ntax_id [new]: 2\r\nquantity_order_min [new]: 1\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_g6wqzzpy.png\",\"usrName\":\"cune_001.png\",\"size\":81750,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_2k0254s4.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8450,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nmaster_num [new]: 0\r\ntype_num [new]: 1\r\nmanufacturers_id [new]: 1\r\ndate_added [new]: 2021-07-20 17:30:04\r\nlast_modified [new]: 2021-08-16 20:04:54\r\nisVisible [new]: 1\r\n'),
 (269,'2021-08-20 12:54:27','127.0.0.1','admin','manufacturers','add','---Keys\r\nid_manufacturers : 3\r\n---Fields\r\nmanufacturer_name [new]: Bodegas CUNE, s.l.\r\nnif [new]: 00000005M\r\nemail_address [new]: info@cune.com\r\npostal_address [new]: Cune\r\ncity [new]: Rioja\r\n'),
 (270,'2021-08-20 12:54:44','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 6\r\n---Fields\r\nprice [old]: 20.5200\r\nprice [new]: 15.54\r\nmanufacturers_id [old]: 1\r\nmanufacturers_id [new]: 3\r\ndate_added [old]: 2021-07-20 17:30:04\r\ndate_added [new]: 2021-08-20 12:54:34\r\nlast_modified [old]: 2021-08-16 20:04:54\r\nlast_modified [new]: 2021-08-20 12:52:56\r\n'),
 (271,'2021-08-20 12:55:07','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 6\r\n---Fields\r\ntype_num [old]: 1\r\ntype_num [new]: 0\r\nlast_modified [old]: 2021-08-20 12:52:56\r\nlast_modified [new]: 2021-08-20 12:54:54\r\n'),
 (272,'2021-08-20 12:55:30','127.0.0.1','admin','products','add','---Keys\r\nid_products : 7\r\n---Fields\r\nmodel [new]: Cune crianza\r\ndescription [new]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p><p></p>  #info_Spanish    Descripción   Datos Técnicos        \r\nprice [new]: 6.5\r\nquantity [new]: 2\r\nisVirtual [new]: 0\r\ntax_id [new]: 2\r\nquantity_order_min [new]: 1\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_obdt93tw.png\",\"usrName\":\"cune_001.png\",\"size\":81750,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_je7v8epc.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8450,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nmaster_num [new]: 0\r\ntype_num [new]: 0\r\nmanufacturers_id [new]: 3\r\ndate_added [new]: 2021-08-20 12:54:34\r\nlast_modified [new]: 2021-08-20 12:54:54\r\nisVisible [new]: 1\r\n'),
 (273,'2021-08-20 13:02:31','127.0.0.1','admin','products','add','---Keys\r\nid_products : 8\r\n---Fields\r\nmodel [new]: Cune joven\r\ndescription [new]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p><p></p>  #info_Spanish    Descripción   Datos Técnicos        \r\nprice [new]: 2.65\r\nquantity [new]: 2\r\nisVirtual [new]: 0\r\ntax_id [new]: 2\r\nquantity_order_min [new]: 1\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_ldvfa9nr.png\",\"usrName\":\"cune_001.png\",\"size\":81750,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_c3xb7aj8.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8450,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nmaster_num [new]: 0\r\ntype_num [new]: 0\r\nmanufacturers_id [new]: 3\r\ndate_added [new]: 2021-08-20 12:54:34\r\nlast_modified [new]: 2021-08-20 12:54:54\r\nisVisible [new]: 1\r\n'),
 (274,'2021-08-20 13:04:27','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 6\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_g6wqzzpy.png\",\"usrName\":\"cune_001.png\",\"size\":81750,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_2k0254s4.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8450,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nimages [new]: \r\nlast_modified [old]: 2021-08-20 12:54:54\r\nlast_modified [new]: 2021-08-20 13:04:22\r\n'),
 (275,'2021-08-20 13:04:46','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 6\r\n---Fields\r\nimages [old]: \r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_vi0j0dyz.png\",\"usrName\":\"cune_001.png\",\"size\":86143,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_8lz6jutd.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":9074,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-20 13:04:22\r\nlast_modified [new]: 2021-08-20 13:04:34\r\n'),
 (276,'2021-08-20 13:09:55','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 6\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_vi0j0dyz.png\",\"usrName\":\"cune_001.png\",\"size\":86143,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_8lz6jutd.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":9074,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nimages [new]: \r\nlast_modified [old]: 2021-08-20 13:04:34\r\nlast_modified [new]: 2021-08-20 13:09:49\r\n'),
 (277,'2021-08-20 13:10:23','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 6\r\n---Fields\r\nimages [old]: \r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_2z2ypuf0.png\",\"usrName\":\"cune_001.png\",\"size\":92951,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_ilbt9ps5.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":9148,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-20 13:09:49\r\nlast_modified [new]: 2021-08-20 13:09:58\r\n'),
 (278,'2021-08-20 13:12:04','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 6\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_2z2ypuf0.png\",\"usrName\":\"cune_001.png\",\"size\":92951,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_ilbt9ps5.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":9148,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001 (1)_9lwp1l5v.png\",\"usrName\":\"cune_001 (1).png\",\"size\":94577,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001 (1)_piznrmpx.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8610,\"searchStr\":\"cune_001 (1).png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-20 13:09:58\r\nlast_modified [new]: 2021-08-20 13:11:50\r\n'),
 (279,'2021-08-20 13:13:11','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 7\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_obdt93tw.png\",\"usrName\":\"cune_001.png\",\"size\":81750,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_je7v8epc.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8450,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001 (1)_d93a222r.png\",\"usrName\":\"cune_001 (1).png\",\"size\":94577,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001 (1)_shy9zinw.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8610,\"searchStr\":\"cune_001 (1).png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-20 12:54:54\r\nlast_modified [new]: 2021-08-20 13:13:00\r\n'),
 (280,'2021-08-20 13:13:26','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 8\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001_ldvfa9nr.png\",\"usrName\":\"cune_001.png\",\"size\":81750,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001_c3xb7aj8.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8450,\"searchStr\":\"cune_001.png,!:sStrEnd\"}]\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/cune_001 (1)_6xuzshw2.png\",\"usrName\":\"cune_001 (1).png\",\"size\":94577,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001 (1)_f13mmra0.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8610,\"searchStr\":\"cune_001 (1).png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-20 12:54:54\r\nlast_modified [new]: 2021-08-20 13:13:14\r\n'),
 (281,'2021-08-20 13:15:07','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 1\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_yifn4f2h.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_s2sjdunm.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_8hbpx8w6.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_c8ssumqc.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-19 20:19:14\r\nlast_modified [new]: 2021-08-20 13:14:54\r\n'),
 (282,'2021-08-20 13:15:18','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 2\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_sm7dk05h.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_bkvklwza.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_8rnltcy0.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_c484jwt1.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-16 20:02:01\r\nlast_modified [new]: 2021-08-20 13:15:10\r\n'),
 (283,'2021-08-20 13:15:33','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 3\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_cl9vx3d6.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_ptd8ec8w.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_798u3pte.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_a7tujjwy.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-16 20:04:54\r\nlast_modified [new]: 2021-08-20 13:15:21\r\n'),
 (284,'2021-08-20 13:15:48','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 4\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_uydrrow6.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_ayvqesrs.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_bdeuqijz.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_700z0kyv.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-16 20:05:07\r\nlast_modified [new]: 2021-08-20 13:15:38\r\n'),
 (285,'2021-08-20 13:16:21','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 5\r\n---Fields\r\nimages [old]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001_jtwsrzd1.png\",\"usrName\":\"vino_001.png\",\"size\":83094,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001_yk5bg4jd.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6704,\"searchStr\":\"vino_001.png,!:sStrEnd\"}]\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_pzj3bezw.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_ixyku9i5.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]\r\nlast_modified [old]: 2021-08-16 19:34:52\r\nlast_modified [new]: 2021-08-20 13:15:57\r\n'),
 (286,'2021-08-20 13:59:31','127.0.0.1','admin','manufacturers','add','---Keys\r\nid_manufacturers : 4\r\n---Fields\r\nmanufacturer_name [new]: HP\r\nnif [new]: 11111\r\nemail_address [new]: info@hp.com\r\npostal_address [new]: su dirección\r\ncity [new]: Barcelona\r\ncode_postal [new]: 08001\r\n'),
 (287,'2021-08-20 14:00:06','127.0.0.1','admin','products','add','---Keys\r\nid_products : 9\r\n---Fields\r\nmodel [new]: HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3\r\ndescription [new]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3</span></p>English#  <p></p>  #info_Spanish<div>\r\nprice [new]: 549\r\nquantity [new]: 1\r\nisVirtual [new]: 0\r\ntax_id [new]: 2\r\nweight [new]: 3\r\nquantity_order_min [new]: 1\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/hp_001_53vx37j9.png\",\"usrName\":\"hp_001.png\",\"size\":215027,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thhp_001_dilo43yr.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":18753,\"searchStr\":\"hp_001.png,!:sStrEnd\"}]\r\nmaster_num [new]: 10\r\ntype_num [new]: 0\r\nmanufacturers_id [new]: 4\r\ndate_added [new]: 2021-08-20 13:43:14\r\nlast_modified [new]: 2021-08-20 13:43:14\r\nisVisible [new]: 0\r\n'),
 (288,'2021-08-20 14:05:21','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 9\r\n---Fields\r\ndescription [old]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3</span></p>English#  <p></p>  #info_Spanish<div>\r\ndescription [new]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3</span></p>English#  <p></p>  #info_Spanish<div>\r\nlast_modified [old]: 2021-08-20 13:43:14\r\nlast_modified [new]: 2021-08-20 14:04:13\r\nisVisible [old]: 0\r\nisVisible [new]: 1\r\n'),
 (289,'2021-08-20 14:07:25','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 9\r\n---Fields\r\ndescription [old]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3</span></p>English#  <p></p>  #info_Spanish<div>\r\ndescription [new]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3-1115G4, 8GB, 256GB SSD, UHD Graphics, W10H, Plata</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ \r\nlast_modified [old]: 2021-08-20 14:04:13\r\nlast_modified [new]: 2021-08-20 14:06:24\r\n'),
 (290,'2021-08-20 19:23:32','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 9\r\n---Fields\r\ncatalog_num [old]: 0\r\ncatalog_num [new]: 3\r\n'),
 (291,'2021-08-20 19:23:43','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 10\r\n---Fields\r\ncatalog_num [old]: 0\r\ncatalog_num [new]: 3\r\n'),
 (292,'2021-08-20 19:23:58','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 43\r\n---Fields\r\ncatalog_num [old]: 0\r\ncatalog_num [new]: 4\r\n'),
 (293,'2021-08-20 19:24:08','127.0.0.1','admin','catalog','edit','---Keys\r\nid_catalog : 44\r\n---Fields\r\ncatalog_num [old]: 0\r\ncatalog_num [new]: 4\r\n'),
 (294,'2021-08-20 19:24:30','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 9\r\n---Fields\r\ndescription [old]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3-1115G4, 8GB, 256GB SSD, UHD Graphics, W10H, Plata</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ \r\ndescription [new]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3-1115G4, 8GB, 256GB SSD, UHD Graphics, W10H, Plata</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ \r\ntype_num [old]: 0\r\ntype_num [new]: 4\r\nlast_modified [old]: 2021-08-20 14:06:24\r\nlast_modified [new]: 2021-08-20 19:24:21\r\n'),
 (295,'2021-08-20 19:52:56','127.0.0.1','admin','type_master','edit','---Keys\r\nid_catalog : 41\r\n---Fields\r\ncatalog_num [old]: 10\r\ncatalog_num [new]: 3\r\n'),
 (296,'2021-08-20 19:53:02','127.0.0.1','admin','type_master','edit','---Keys\r\nid_catalog : 42\r\n---Fields\r\ncatalog_num [old]: 10\r\ncatalog_num [new]: 3\r\n'),
 (297,'2021-08-20 19:53:24','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 43\r\n---Fields\r\ngroup_num [old]: 10\r\ngroup_num [new]: 3\r\n'),
 (298,'2021-08-20 19:54:41','127.0.0.1','admin','type','edit','---Keys\r\nid_catalog : 44\r\n---Fields\r\ngroup_num [old]: 10\r\ngroup_num [new]: 3\r\n'),
 (299,'2021-08-20 20:02:11','127.0.0.1','admin','type_master','add','---Keys\r\nid_catalog : 45\r\n---Fields\r\nlanguage [new]: Spanish\r\ncatalog_num [new]: 4\r\ncatalog_code [new]: Teléfonos\r\ncatalog_master_id [new]: 2\r\n'),
 (300,'2021-08-20 20:02:21','127.0.0.1','admin','type_master','delete','---Keys\r\nid_catalog : 45\r\n---Fields\r\ncatalog_master_id [old]: 2\r\nlanguage [old]: Spanish\r\ncatalog_num [old]: 4\r\ncatalog_code [old]: Teléfonos\r\n'),
 (301,'2021-08-20 20:05:15','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 9\r\n---Fields\r\nmaster_num [old]: 10\r\nmaster_num [new]: 3\r\nlast_modified [old]: 2021-08-20 19:24:21\r\nlast_modified [new]: 2021-08-20 20:05:03\r\n'),
 (302,'2021-08-20 20:23:39','127.0.0.1','admin','users','add','---Keys\r\nid_users : 2\r\n---Fields\r\nlogin [new]: gestor\r\npassword [new]: a55607442fca264cf37e935503d646c2\r\nname [new]: Usuario Gestor\r\n'),
 (303,'2021-08-20 20:23:48','127.0.0.1','admin','users','logout',''),
 (304,'2021-08-20 20:23:59','127.0.0.1','gestor','users','login',''),
 (305,'2021-08-20 20:27:25','127.0.0.1','gestor','products','add','---Keys\r\nid_products : 10\r\n---Fields\r\nmodel [new]: HP Laptop 15s-eq1033ns, 15.6\" HD, AMD 3020e\r\ndescription [new]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">Portátil - HP Laptop 15s-eq1033ns, 15.6\" HD, AMD 3020e, 4GB, 256GB SSD, Radeon™, W10 Home, Azul índigo</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">Portátil - HP Laptop 15s-eq1033ns, 15.6\" H\r\nprice [new]: 349\r\nquantity [new]: 1\r\nisVirtual [new]: 0\r\ntax_id [new]: 2\r\nquantity_order_min [new]: 1\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/hp_001_7xyxp2c5.png\",\"usrName\":\"hp_001.png\",\"size\":215027,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thhp_001_kobna79w.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":18753,\"searchStr\":\"hp_001.png,!:sStrEnd\"}]\r\nmaster_num [new]: 3\r\ntype_num [new]: 4\r\nmanufacturers_id [new]: 4\r\ndate_added [new]: 2021-08-20 20:25:33\r\nlast_modified [new]: 2021-08-20 20:25:33\r\nisVisible [new]: 0\r\n'),
 (306,'2021-08-20 20:29:55','127.0.0.1','gestor','products','add','---Keys\r\nid_products : 11\r\n---Fields\r\nmodel [new]: HP 250 G8 15.6\" FHD, Intel® Core™ i3-1115G4\r\ndescription [new]: #Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">Portátil - HP 250 G8 15.6\" FHD, Intel® Core™ i3-1115G4, 8 GB, 256 GB SSD, W10 Home, Grafito</p>Spanish# #English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">Portátil - HP 250 G8 15.6\" FHD, Intel® Core™ i3-1115G\r\nprice [new]: 549\r\nquantity [new]: 10\r\nisVirtual [new]: 0\r\ntax_id [new]: 2\r\nquantity_order_min [new]: 1\r\nimages [new]: [{\"name\":\"..\\/ecommerce\\/files\\/hp_001_dwhi2ujl.png\",\"usrName\":\"hp_001.png\",\"size\":215027,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thhp_001_n0d92eh1.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":18753,\"searchStr\":\"hp_001.png,!:sStrEnd\"}]\r\nmaster_num [new]: 3\r\ntype_num [new]: 4\r\nmanufacturers_id [new]: 4\r\ndate_added [new]: 2021-08-20 20:27:56\r\nlast_modified [new]: 2021-08-20 20:27:56\r\nisVisible [new]: 1\r\n'),
 (307,'2021-08-20 20:30:09','127.0.0.1','gestor','products','edit','---Keys\r\nid_products : 10\r\n---Fields\r\nlast_modified [old]: 2021-08-20 20:25:33\r\nlast_modified [new]: 2021-08-20 20:30:04\r\nisVisible [old]: 0\r\nisVisible [new]: 1\r\n'),
 (308,'2021-08-21 20:52:47','127.0.0.1','gestor','products','edit','---Keys\r\nid_products : 9\r\n---Fields\r\nlast_modified [old]: 2021-08-20 20:05:03\r\nlast_modified [new]: 2021-08-21 20:52:08\r\n'),
 (309,'2021-08-21 20:54:09','127.0.0.1','gestor','products','edit','---Keys\r\nid_products : 9\r\n---Fields\r\nlast_modified [old]: 2021-08-21 20:52:08\r\nlast_modified [new]: 2021-08-21 20:53:22\r\n'),
 (310,'2021-08-23 20:05:00','::1','admin','users','login',''),
 (311,'2021-08-23 20:05:46','::1','admin','customers','edit','---Keys\r\nid_customers : 2\r\n---Fields\r\npassword [old]: 1191ea6cf52864ab243eda0e23b3fd42\r\npassword [new]: humanes\r\n'),
 (312,'2021-08-23 20:37:56','::1','admin','users','logout',''),
 (313,'2021-08-24 13:46:36','127.0.0.1','humanes','users','failed login',''),
 (314,'2021-08-24 13:46:40','127.0.0.1','admin','users','login',''),
 (315,'2021-08-24 17:41:06','127.0.0.1','admin','products','edit','---Keys\r\nid_products : 6\r\n---Fields\r\ndescription [old]: <p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p> #English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p><p></p>  #info_Spanish    Descripción   Datos Técnicos        \r\ndescription [new]: #Spanish<p>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.</p>Spanish# #English<p>Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel.</p>English#  <p></p>  #info_Spanish<div> <ul class=\"nav nav-tabs\">   <li class=\"\r\nlast_modified [old]: 2021-08-20 13:11:50\r\nlast_modified [new]: 2021-08-24 17:40:28\r\n'),
 (316,'2021-08-25 14:14:51','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 10\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-24 21:27:03\r\nlast_modified [old]: 2021-08-25 13:54:33\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (317,'2021-08-25 14:14:51','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 11\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-24 21:27:03\r\nlast_modified [old]: 2021-08-25 13:54:33\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (318,'2021-08-25 19:04:36','127.0.0.1','admin','users','login',''),
 (319,'2021-08-25 19:04:57','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 12\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-25 14:14:12\r\nlast_modified [old]: 2021-08-25 18:52:38\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (320,'2021-08-25 19:04:57','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 13\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-25 18:52:44\r\nlast_modified [old]: 2021-08-25 18:56:43\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (321,'2021-08-25 19:04:57','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 14\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-25 18:57:01\r\nlast_modified [old]: 2021-08-25 19:00:28\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (322,'2021-08-25 19:04:57','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 15\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-25 19:00:48\r\nlast_modified [old]: 2021-08-25 19:01:53\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (323,'2021-08-25 19:04:57','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 16\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-25 19:02:09\r\nlast_modified [old]: 2021-08-25 19:03:36\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (324,'2021-08-25 19:04:57','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 17\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 0\r\ndate_added [old]: 2021-08-25 19:03:59\r\nlast_modified [old]: 2021-08-25 19:03:59\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (325,'2021-08-25 19:39:42','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 19\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-25 19:25:46\r\nlast_modified [old]: 2021-08-25 19:25:54\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n'),
 (326,'2021-08-25 19:39:42','127.0.0.1','admin','orders','delete','---Keys\r\nid_orders : 20\r\n---Fields\r\ncustomers_id [old]: 2\r\norder_status [old]: 1\r\ndate_added [old]: 2021-08-25 19:26:07\r\nlast_modified [old]: 2021-08-25 19:31:43\r\nproduct_count [old]: 0\r\namount_total [old]: 0.0000\r\ntax_total [old]: 0.0000\r\ntotal_total [old]: 0.0000\r\n');
/*!40000 ALTER TABLE `ecommerce_priv_audit` ENABLE KEYS */;


--
-- Definition of table `ecommerce_priv_uggroups`
--

DROP TABLE IF EXISTS `ecommerce_priv_uggroups`;
CREATE TABLE `ecommerce_priv_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ecommerce_priv_uggroups`
--

/*!40000 ALTER TABLE `ecommerce_priv_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `ecommerce_priv_uggroups` ENABLE KEYS */;


--
-- Definition of table `ecommerce_priv_ugmembers`
--

DROP TABLE IF EXISTS `ecommerce_priv_ugmembers`;
CREATE TABLE `ecommerce_priv_ugmembers` (
  `UserName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  PRIMARY KEY (`UserName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ecommerce_priv_ugmembers`
--

/*!40000 ALTER TABLE `ecommerce_priv_ugmembers` DISABLE KEYS */;
INSERT INTO `ecommerce_priv_ugmembers` (`UserName`,`GroupID`) VALUES 
 ('admin',-1);
/*!40000 ALTER TABLE `ecommerce_priv_ugmembers` ENABLE KEYS */;


--
-- Definition of table `ecommerce_priv_ugrights`
--

DROP TABLE IF EXISTS `ecommerce_priv_ugrights`;
CREATE TABLE `ecommerce_priv_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  `Page` mediumtext,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `ecommerce_priv_ugrights`
--

/*!40000 ALTER TABLE `ecommerce_priv_ugrights` DISABLE KEYS */;
INSERT INTO `ecommerce_priv_ugrights` (`TableName`,`GroupID`,`AccessMask`,`Page`) VALUES 
 ('catalog',-2,'AEDSPI',''),
 ('catalog',-1,'ADESPIM',NULL),
 ('catalog_master',-2,'AEDSPI',''),
 ('catalog_master',-1,'ADESPIM',NULL),
 ('customers',-2,'AEDSPI',''),
 ('customers',-1,'ADESPIM',NULL),
 ('delivery_note',-2,'AEDSPI',''),
 ('delivery_note',-1,'ADESPIM',NULL),
 ('delivery_products',-2,'S',''),
 ('delivery_products',-1,'SPIM',''),
 ('lv_catalog',-2,'S',''),
 ('lv_catalog',-1,'S',''),
 ('lv_products',-2,'S',''),
 ('lv_products',-1,'S',''),
 ('manufacturers',-2,'AEDSPI',''),
 ('manufacturers',-1,'ADESPIM',NULL),
 ('orders',-2,'AEDS',''),
 ('orders',-1,'ADESPIM',NULL),
 ('orders_products',-2,'S',''),
 ('orders_products',-1,'SPIM',''),
 ('products',-2,'AEDSP',''),
 ('products',-1,'ADESPIM',NULL),
 ('tax',-2,'AEDSPI',''),
 ('tax',-1,'ADESPIM',NULL),
 ('type',-2,'AEDSP',''),
 ('type',-1,'ADESPIM',NULL),
 ('type_master',-2,'AEDSP',''),
 ('type_master',-1,'ADESPIM',NULL),
 ('users',-1,'ADESPIM',NULL);
/*!40000 ALTER TABLE `ecommerce_priv_ugrights` ENABLE KEYS */;


--
-- Definition of table `manufacturers`
--

DROP TABLE IF EXISTS `manufacturers`;
CREATE TABLE `manufacturers` (
  `id_manufacturers` int(11) NOT NULL AUTO_INCREMENT,
  `manufacturer_name` varchar(100) NOT NULL,
  `nif` varchar(12) NOT NULL,
  `email_address` varchar(100) NOT NULL,
  `telephone` varchar(12) NOT NULL,
  `postal_address` varchar(300) NOT NULL,
  `city` varchar(100) NOT NULL,
  `code_postal` varchar(10) NOT NULL,
  PRIMARY KEY (`id_manufacturers`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `manufacturers`
--

/*!40000 ALTER TABLE `manufacturers` DISABLE KEYS */;
INSERT INTO `manufacturers` (`id_manufacturers`,`manufacturer_name`,`nif`,`email_address`,`telephone`,`postal_address`,`city`,`code_postal`) VALUES 
 (1,'Bodegas Pesquera, S.L.','5M','info@perquera.com','','Calle','Rioja',''),
 (2,'Bodegas Protos, S.A.','000000005M','info@protos.com','','Bodegas Proto','Valladolid',''),
 (3,'Bodegas CUNE, s.l.','00000005M','info@cune.com','','Cune','Rioja',''),
 (4,'HP','11111','info@hp.com','','su dirección','Barcelona','08001');
/*!40000 ALTER TABLE `manufacturers` ENABLE KEYS */;


--
-- Definition of table `orders`
--

DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id_orders` int(11) NOT NULL AUTO_INCREMENT,
  `customers_id` int(11) NOT NULL,
  `order_status` int(11) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  `last_modified` datetime NOT NULL,
  `product_count` int(11) NOT NULL DEFAULT '0',
  `amount_total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `tax_total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  `total_total` decimal(15,4) NOT NULL DEFAULT '0.0000',
  PRIMARY KEY (`id_orders`),
  KEY `fk_orders_customers1_idx` (`customers_id`),
  CONSTRAINT `fk_orders_customers1` FOREIGN KEY (`customers_id`) REFERENCES `customers` (`id_customers`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `orders`
--

/*!40000 ALTER TABLE `orders` DISABLE KEYS */;
INSERT INTO `orders` (`id_orders`,`customers_id`,`order_status`,`date_added`,`last_modified`,`product_count`,`amount_total`,`tax_total`,`total_total`) VALUES 
 (3,1,8,'2021-07-20 19:58:01','2021-08-12 12:52:25',3,'49.8950','10.4780','60.3729'),
 (5,1,0,'2021-07-22 19:08:05','2021-07-22 19:08:05',1,'15.1250','3.1763','18.3012'),
 (6,1,0,'2021-07-25 18:46:17','2021-07-25 18:46:17',1,'15.1250','3.1763','18.3012'),
 (7,2,1,'2021-08-22 20:35:41','2021-08-24 17:22:45',1,'151.2500','31.7625','183.0125'),
 (8,2,1,'2021-08-24 17:23:01','2021-08-24 21:27:03',1,'1098.0000','230.5800','1328.5800'),
 (9,2,1,'2021-08-24 21:27:03','2021-08-25 14:05:19',1,'15.1250','3.1763','18.3013'),
 (18,2,1,'2021-08-25 19:05:18','2021-08-25 19:25:46',2,'30.2500','6.3526','36.6026'),
 (21,2,1,'2021-08-25 19:32:10','2021-08-25 19:40:00',1,'15.1250','3.1763','18.3013'),
 (22,2,1,'2021-08-25 19:40:00','2021-08-27 19:29:33',1,'15.1250','3.1763','18.3013'),
 (23,2,0,'2021-08-27 19:29:33','2021-08-27 19:54:39',1,'65.0000','13.6500','78.6500');
/*!40000 ALTER TABLE `orders` ENABLE KEYS */;


--
-- Definition of table `orders_products`
--

DROP TABLE IF EXISTS `orders_products`;
CREATE TABLE `orders_products` (
  `id_orders_products` int(11) NOT NULL AUTO_INCREMENT,
  `orders_id` int(11) NOT NULL,
  `products_id` int(11) NOT NULL,
  `quantity` int(11) NOT NULL DEFAULT '0',
  `price` decimal(15,4) NOT NULL,
  `amount` decimal(15,4) NOT NULL,
  `tax_amount` decimal(15,4) NOT NULL,
  `total` decimal(15,4) NOT NULL,
  `date_added` datetime NOT NULL,
  `last_modified` datetime NOT NULL,
  PRIMARY KEY (`id_orders_products`),
  KEY `fk_orders_products_orders1_idx` (`orders_id`),
  KEY `fk_orders_products_products1_idx` (`products_id`),
  CONSTRAINT `fk_orders_products_orders1` FOREIGN KEY (`orders_id`) REFERENCES `orders` (`id_orders`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_orders_products_products1` FOREIGN KEY (`products_id`) REFERENCES `products` (`id_products`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=79 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `orders_products`
--

/*!40000 ALTER TABLE `orders_products` DISABLE KEYS */;
INSERT INTO `orders_products` (`id_orders_products`,`orders_id`,`products_id`,`quantity`,`price`,`amount`,`tax_amount`,`total`,`date_added`,`last_modified`) VALUES 
 (7,3,2,1,'14.2500','14.2500','2.9925','17.2425','2021-07-20 19:58:41','2021-07-22 13:54:48'),
 (14,3,3,1,'20.5200','20.5200','4.3092','24.8292','2021-07-22 13:58:03','2021-07-22 14:08:26'),
 (22,5,1,1,'15.1250','15.1250','3.1763','18.3012','2021-07-22 19:09:03','2021-07-22 19:09:03'),
 (24,3,1,1,'15.1250','15.1250','3.1763','18.3012','2021-07-22 19:11:55','2021-07-22 19:11:55'),
 (25,6,1,1,'15.1250','15.1250','3.1763','18.3012','2021-07-25 18:46:36','2021-07-25 18:46:36'),
 (26,7,1,10,'15.1250','151.2500','31.7625','183.0125','2021-08-22 20:45:27','2021-08-24 14:23:13'),
 (27,8,9,2,'549.0000','1098.0000','230.5800','1328.5800','2021-08-24 21:25:57','2021-08-24 21:26:34'),
 (28,9,5,1,'15.1250','15.1250','3.1763','18.3013','2021-08-24 21:31:00','2021-08-24 21:31:00'),
 (29,18,1,1,'15.1250','15.1250','3.1763','18.3013','2021-08-25 19:06:09','2021-08-25 19:06:09'),
 (30,18,1,1,'15.1250','15.1250','3.1763','18.3013','2021-08-25 19:21:40','2021-08-25 19:21:40'),
 (31,21,1,1,'15.1250','15.1250','3.1763','18.3013','2021-08-25 19:39:16','2021-08-25 19:39:16'),
 (77,22,1,1,'15.1250','15.1250','3.1763','18.3013','2021-08-27 19:29:23','2021-08-27 19:29:23'),
 (78,23,7,10,'6.5000','65.0000','13.6500','78.6500','2021-08-27 19:54:15','2021-08-27 19:54:30');
/*!40000 ALTER TABLE `orders_products` ENABLE KEYS */;


--
-- Definition of table `products`
--

DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
  `id_products` int(11) NOT NULL AUTO_INCREMENT,
  `master_num` int(11) NOT NULL,
  `type_num` int(11) NOT NULL,
  `tax_id` int(11) NOT NULL,
  `manufacturers_id` int(11) NOT NULL,
  `model` varchar(100) NOT NULL,
  `description` mediumtext,
  `images` varchar(2000) DEFAULT NULL,
  `price` decimal(15,4) DEFAULT NULL,
  `isVirtual` int(11) NOT NULL DEFAULT '0',
  `quantity` int(11) NOT NULL DEFAULT '0',
  `date_added` datetime NOT NULL,
  `last_modified` datetime NOT NULL,
  `date_available` datetime DEFAULT NULL,
  `weight` float DEFAULT NULL,
  `quantity_order_min` int(11) NOT NULL DEFAULT '1',
  `isVisible` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id_products`),
  KEY `fk_products_tax1_idx` (`tax_id`),
  KEY `fk_products_manufacturers1_idx` (`manufacturers_id`),
  KEY `idx_type_num` (`type_num`) USING BTREE,
  KEY `idx_master_num` (`master_num`) USING BTREE,
  CONSTRAINT `fk_products_manufacturers1` FOREIGN KEY (`manufacturers_id`) REFERENCES `manufacturers` (`id_manufacturers`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `fk_products_tax1` FOREIGN KEY (`tax_id`) REFERENCES `tax` (`id_tax`) ON DELETE NO ACTION ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `products`
--

/*!40000 ALTER TABLE `products` DISABLE KEYS */;
INSERT INTO `products` (`id_products`,`master_num`,`type_num`,`tax_id`,`manufacturers_id`,`model`,`description`,`images`,`price`,`isVirtual`,`quantity`,`date_added`,`last_modified`,`date_available`,`weight`,`quantity_order_min`,`isVisible`) VALUES 
 (1,0,1,2,1,'Pesquera crianza 2018','#Spanish<p>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.</p>Spanish#\r\n#English<p>Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel.</p>English#\r\n\r\n<p></p>\r\n\r\n#info_Spanish<div>\r\n<ul class=\"nav nav-tabs\">\r\n  <li class=\"active\"><a data-toggle=\"tab\" href=\"#tab1_spanish\" aria-expanded=\"true\">Descripción</a></li>\r\n  <li class=\"\"><a data-toggle=\"tab\" href=\"#tab2_spanish\" aria-expanded=\"false\">Datos Técnicos</a></li>\r\n</ul>\r\n\r\n<div class=\"tab-content\">\r\n  <div id=\"tab1_spanish\" class=\"tab-pane fade active in\">\r\n    <h4>Descripción</h4>\r\n    <p>A</p></div>\r\n\r\n  <div id=\"tab2_spanish\" class=\"tab-pane fade\">\r\n    <h4>Datos Técnicos</h4>\r\n    <p>B</p>\r\n    </div>\r\n</div>\r\n</div>info_Spanish#\r\n\r\n\r\n<p></p>\r\n\r\n#info_English<div>\r\n<ul class=\"nav nav-tabs\">\r\n  <li class=\"active\"><a data-toggle=\"tab\" href=\"#tab1_english\" aria-expanded=\"true\">Description</a></li>\r\n  <li class=\"\"><a data-toggle=\"tab\" href=\"#tab2_english\" aria-expanded=\"false\">Technical data</a></li>\r\n</ul>\r\n\r\n<div class=\"tab-content\">\r\n  <div id=\"tab1_english\" class=\"tab-pane fade active in\">\r\n    <h4>Description</h4>\r\n    <p>A</p></div>\r\n\r\n  <div id=\"tab2_english\" class=\"tab-pane fade\">\r\n    <h4>Technical data</h4>\r\n    <p>B</p>\r\n    </div>\r\n</div>\r\n</div>info_English#','[{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_8hbpx8w6.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_c8ssumqc.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]','15.1250',0,10,'2021-07-15 18:29:07','2021-08-20 13:14:54',NULL,NULL,1,1),
 (2,0,1,2,2,'Protos crianza','<p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p>\r\n#English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>','[{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_8rnltcy0.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_c484jwt1.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]','14.2500',0,5,'2021-07-20 17:18:23','2021-08-20 13:15:10',NULL,NULL,1,1),
 (3,0,1,2,1,'Pesquera reserva','<p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p>\r\n#English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>','[{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_798u3pte.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_a7tujjwy.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]','20.5200',0,2,'2021-07-20 17:30:04','2021-08-20 13:15:21',NULL,NULL,1,1),
 (4,0,1,2,1,'Pesquera crianza 2019','<p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p>\r\n#English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p>','[{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_bdeuqijz.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_700z0kyv.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]','15.1250',0,10,'2021-08-16 19:35:24','2021-08-20 13:15:38',NULL,NULL,1,1),
 (5,0,1,2,1,'Pesquera crianza 2020','#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish#\r\n\r\n#English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#\r\n','[{\"name\":\"..\\/ecommerce\\/files\\/vino_001 (1)_pzj3bezw.png\",\"usrName\":\"vino_001 (1).png\",\"size\":89394,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thvino_001 (1)_ixyku9i5.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":6980,\"searchStr\":\"vino_001 (1).png,!:sStrEnd\"}]','15.1250',0,10,'2021-07-15 18:29:07','2021-08-20 13:15:57',NULL,NULL,1,1),
 (6,0,0,2,3,'Cune reserva','#Spanish<p>Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano.</p>Spanish#\r\n#English<p>Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel.</p>English#\r\n\r\n<p></p>\r\n\r\n#info_Spanish<div>\r\n<ul class=\"nav nav-tabs\">\r\n  <li class=\"active\"><a data-toggle=\"tab\" href=\"#tab1_spanish\" aria-expanded=\"true\">Descripción</a></li>\r\n  <li class=\"\"><a data-toggle=\"tab\" href=\"#tab2_spanish\" aria-expanded=\"false\">Datos Técnicos</a></li>\r\n</ul>\r\n\r\n<div class=\"tab-content\">\r\n  <div id=\"tab1_spanish\" class=\"tab-pane fade active in\">\r\n    <h4>Descripción</h4>\r\n    <p>A</p></div>\r\n\r\n  <div id=\"tab2_spanish\" class=\"tab-pane fade\">\r\n    <h4>Datos Técnicos</h4>\r\n    <p>B</p>\r\n    </div>\r\n</div>\r\n</div>info_Spanish#\r\n\r\n\r\n<p></p>\r\n\r\n#info_English<div>\r\n<ul class=\"nav nav-tabs\">\r\n  <li class=\"active\"><a data-toggle=\"tab\" href=\"#tab1_english\" aria-expanded=\"true\">Description</a></li>\r\n  <li class=\"\"><a data-toggle=\"tab\" href=\"#tab2_english\" aria-expanded=\"false\">Technical data</a></li>\r\n</ul>\r\n\r\n<div class=\"tab-content\">\r\n  <div id=\"tab1_english\" class=\"tab-pane fade active in\">\r\n    <h4>Description</h4>\r\n    <p>A</p></div>\r\n\r\n  <div id=\"tab2_english\" class=\"tab-pane fade\">\r\n    <h4>Technical data</h4>\r\n    <p>B</p>\r\n    </div>\r\n</div>\r\n</div>info_English#','[{\"name\":\"..\\/ecommerce\\/files\\/cune_001 (1)_9lwp1l5v.png\",\"usrName\":\"cune_001 (1).png\",\"size\":94577,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001 (1)_piznrmpx.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8610,\"searchStr\":\"cune_001 (1).png,!:sStrEnd\"}]','15.5400',0,2,'2021-08-20 12:54:34','2021-08-24 17:40:28',NULL,NULL,1,1),
 (7,0,0,2,3,'Cune crianza','<p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p>\r\n#English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p><p></p>\r\n\r\n#info_Spanish\r\n\r\n  Descripción\r\n  Datos Técnicos\r\n\r\n\r\n\r\n  \r\n    Descripción\r\n    <p>A</p>\r\n\r\n  \r\n    Datos Técnicos\r\n    <p>B</p>\r\n    \r\n\r\ninfo_Spanish#\r\n\r\n\r\n<p></p>\r\n\r\n#info_English\r\n\r\n  Description\r\n  Technical data\r\n\r\n\r\n\r\n  \r\n    Description\r\n    <p>A</p>\r\n\r\n  \r\n    Technical data\r\n    <p>B</p>\r\n    \r\n\r\ninfo_English#','[{\"name\":\"..\\/ecommerce\\/files\\/cune_001 (1)_d93a222r.png\",\"usrName\":\"cune_001 (1).png\",\"size\":94577,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001 (1)_shy9zinw.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8610,\"searchStr\":\"cune_001 (1).png,!:sStrEnd\"}]','6.5000',0,2,'2021-08-20 12:54:34','2021-08-20 13:13:00',NULL,NULL,1,1),
 (8,0,0,2,3,'Cune joven','<p>#Spanish Vino con al menos 3 años de crianza, con sabor afrutado y curado en barrica de roble americano Spanish# <br></p><p>\r\n#English Wine with at least 3 years of aging, with fruity flavor and cured in American oak barrel English#</p><p></p>\r\n\r\n#info_Spanish\r\n\r\n  Descripción\r\n  Datos Técnicos\r\n\r\n\r\n\r\n  \r\n    Descripción\r\n    <p>A</p>\r\n\r\n  \r\n    Datos Técnicos\r\n    <p>B</p>\r\n    \r\n\r\ninfo_Spanish#\r\n\r\n\r\n<p></p>\r\n\r\n#info_English\r\n\r\n  Description\r\n  Technical data\r\n\r\n\r\n\r\n  \r\n    Description\r\n    <p>A</p>\r\n\r\n  \r\n    Technical data\r\n    <p>B</p>\r\n    \r\n\r\ninfo_English#','[{\"name\":\"..\\/ecommerce\\/files\\/cune_001 (1)_6xuzshw2.png\",\"usrName\":\"cune_001 (1).png\",\"size\":94577,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thcune_001 (1)_f13mmra0.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":8610,\"searchStr\":\"cune_001 (1).png,!:sStrEnd\"}]','2.6500',0,2,'2021-08-20 12:54:34','2021-08-20 13:13:14',NULL,NULL,1,1),
 (9,3,4,2,4,'HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3','#Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3-1115G4, 8GB, 256GB SSD, UHD Graphics, W10H, Plata</p>Spanish#\r\n#English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">HP Laptop 14s-dq2000ns, 14\" FHD, Intel® Core™ i3-1115G4, 8GB, 256GB SSD, UHD Graphics, W10H, Plata</span></p>English#\r\n\r\n<p></p>\r\n\r\n#info_Spanish<div>\r\n<ul class=\"nav nav-tabs\">\r\n  <li class=\"\"><a data-toggle=\"tab\" href=\"#tab1_spanish\" aria-expanded=\"false\">Descripción</a></li>\r\n  <li class=\"active\"><a data-toggle=\"tab\" href=\"#tab2_spanish\" aria-expanded=\"true\">Datos Técnicos</a></li>\r\n</ul>\r\n\r\n<div class=\"tab-content\">\r\n  <div id=\"tab1_spanish\" class=\"tab-pane fade\"><div data-test=\"mms-info-text-teaser\"><div data-test=\"mms-info-teaser-regular\" class=\"Teasersstyled__StyledInfoTeaserRegular-sc-1eyd2y-7 jxQwK\"><p color=\"black\" id=\"info-teaser\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 cgPmWf\"><font color=\"#FFFFFF\"><span style=\"background-color: rgb(255, 128, 128);\">Promoción 3 Meses GRATIS Office 365</span></font></p><div class=\"Badgestyled__StyledBadgeLineWrapper-o6cwa5-1 broXDE Teasersstyled__StyledBadge-sc-1eyd2y-0 injkXP\"><div data-test=\"mms-badge\" class=\"Badgestyled__StyledBadgeWrapper-o6cwa5-2 eDTJQY\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dqOBxE Badgestyled__StyledTypo-o6cwa5-0 efxBFT\"><div class=\"Badgestyled__StyledOverflow-o6cwa5-3 eVUgcy\">Promoción 3 Meses GRATIS Office 365</div></span></div></div><p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 fSoIAm\">Compra Office 365 de forma conjunta con tu nuevo portátil o PC y consigue GRATIS 3 meses extra. </p><p color=\"grey5\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gQDatN\"><a class=\"Linkstyled__StyledLinkAnchor-sc-1drhx1h-0 lkgMQP\" target=\"_blank\" rel=\"noopener noreferrer\" href=\"http://mediamarkt.es/es/specials/microsoft-365\">Obtén aquí los 3 meses extra </a></p><p color=\"grey3\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 hCkLwM\">Consigue\r\n hoy tus 3 meses extra siguiendo estos pasos: 1) Solicita en los 30 días\r\n posteriores a tu compra el código de descarga de 3 meses. 2) Selecciona\r\n \"Solicitar\" e introduce el código de 25 dígitos de tu suscripción \r\nOffice 365 (12 meses). 3) Completa los pasos de la petición y sube tu \r\nrecibo de compra. 4) Recibirás un nuevo código de suscripción de 3 meses\r\n por email en los 10 días siguientes al envío de la petición. </p></div></div><p>Con\r\n el portátil HP Laptop 14s-dq2000ns, podrás conectarte desde cualquier \r\nsitio porque viene con una gran duración de la batería. Estés donde \r\nestés, su rendimiento y amplia pantalla, te acompañarán en los días más \r\najetreados.</p><h4 color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 fBpfGp\">Rendimiento revolucionario</h4><p>Potencia la vida y el trabajo portátil con el procesador <strong>Intel® Core™ de 11ᵃ generación</strong>\r\n que ofrece un rendimiento espectacular para la productividad en las \r\ntareas generales, de estudio y de pequeñas empresas. Asegura tu \r\nmovilidad con una carga rápida, batería de larga duración y potente \r\nprocesador, un streaming fluido con el <strong>rendimiento inteligente de Intel®,</strong> una excelente experiencia de entretenimiento en 4K. Además, está equipado con <strong>8 GB de RAM DDR4 de 2666 MHz</strong> con lo que podrás trabajar con varios procesos simultáneamente sin problemas.</p><h4 color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 fBpfGp\">Pantalla FHD</h4><p>Con una <strong>pantalla de 14\" en FHD</strong> y con panel antirreflectante, podrás disfrutar de imágenes, vídeos, películas, series y más; con <strong>gran nitidez.</strong></p><h4 color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 fBpfGp\">Almacenamiento de 256 GB</h4><p>Se inicia en cuestión de segundos, con velocidad de vértigo y <strong>hasta 256 GB de almacenamiento PCIe SSD.</strong></p></div>\r\n\r\n  <div id=\"tab2_spanish\" class=\"tab-pane fade active in\"><table class=\"Tablestyled__StyledTable-sc-1lcy5op-0 iOnmJP\"><thead class=\"TableHeadstyled__StyledTableHead-iazyh2-0 icZHuo\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 gVkPmh\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 jYJtBV\">Pantalla</span></th><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 eBpmMV\"><br></th></tr></thead><tbody class=\"TableBodystyled__StyledTableBody-v8xzh9-0 xXwGe\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño pantalla (cm/pulg)</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">35.5 cm / 14 \"</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Resolución</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">1920 x 1080 píxeles</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Pantalla táctil</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">No</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Calidad de imagen</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">Full-HD</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño pantalla (cm)</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">35.5 cm</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño pantalla (pulgadas)      <br></span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">14 \"</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tipo de pantalla</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">IPS</td></tr><tr><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><br></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\"><br></td></tr></tbody></table><table class=\"Tablestyled__StyledTable-sc-1lcy5op-0 iOnmJP\"><thead class=\"TableHeadstyled__StyledTableHead-iazyh2-0 icZHuo\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 gVkPmh\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 jYJtBV\">Memoria RAM</span></th><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 eBpmMV\"><br></th></tr></thead><tbody class=\"TableBodystyled__StyledTableBody-v8xzh9-0 xXwGe\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tipo de RAM</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">DDR4</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño memoria RAM     <br></span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">8 GB</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Velocidad RAM</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">2666 MHz</td></tr><tr><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><br></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\"><br></td></tr></tbody></table><table class=\"Tablestyled__StyledTable-sc-1lcy5op-0 iOnmJP\"><thead class=\"TableHeadstyled__StyledTableHead-iazyh2-0 icZHuo\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 gVkPmh\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 jYJtBV\">Procesador</span></th><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 eBpmMV\"><br></th></tr></thead><tbody class=\"TableBodystyled__StyledTableBody-v8xzh9-0 xXwGe\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">Intel® Core™ i3-1115G4</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Marca del procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">Intel®</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Modelo del procesador        <br></span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">Core™ i3</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Número Procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">i3-1115G4</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Velocidad Procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">1.7 GHz</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Número de núcleos</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">2</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Vel. turbo procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">4.1 GHz</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño de caché</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">6 MB</td></tr><tr><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><br></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\"><br></td></tr></tbody></table><br><table class=\"Tablestyled__StyledTable-sc-1lcy5op-0 iOnmJP\"><thead class=\"TableHeadstyled__StyledTableHead-iazyh2-0 icZHuo\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 gVkPmh\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 jYJtBV\">Tarjeta gráfica</span></th><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 eBpmMV\"><br></th></tr></thead><tbody class=\"TableBodystyled__StyledTableBody-v8xzh9-0 xXwGe\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tarjeta gráfica                                          <br></span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">UHD Graphics</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\" id=\"pdp-features-last-always-visible\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Fabricante Tarjeta Grafica</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\"> Intel®</td></tr><tr><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><br></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\"><br></td></tr></tbody></table></div>\r\n</div>\r\n</div>info_Spanish#\r\n\r\n\r\n<p></p>\r\n\r\n#info_English<div>\r\n<ul class=\"nav nav-tabs\">\r\n  <li class=\"\"><a data-toggle=\"tab\" href=\"#tab1_english\" aria-expanded=\"false\">Description</a></li>\r\n  <li class=\"active\"><a data-toggle=\"tab\" href=\"#tab2_english\" aria-expanded=\"true\">Technical data</a></li>\r\n</ul>\r\n\r\n<div class=\"tab-content\">\r\n  <div id=\"tab1_english\" class=\"tab-pane fade\"><span id=\"edit1_description_0\" class=\"bs-ctrlspan \"><div id=\"tab1_spanish\" class=\"tab-pane fade active in\"><div data-test=\"mms-info-text-teaser\"><div data-test=\"mms-info-teaser-regular\" class=\"Teasersstyled__StyledInfoTeaserRegular-sc-1eyd2y-7 jxQwK\"><p color=\"black\" id=\"info-teaser\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 cgPmWf\"><font color=\"#FFFFFF\"><span style=\"background-color: rgb(255, 128, 128);\">Promoción 3 Meses GRATIS Office 365</span></font></p><div class=\"Badgestyled__StyledBadgeLineWrapper-o6cwa5-1 broXDE Teasersstyled__StyledBadge-sc-1eyd2y-0 injkXP\"><div data-test=\"mms-badge\" class=\"Badgestyled__StyledBadgeWrapper-o6cwa5-2 eDTJQY\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dqOBxE Badgestyled__StyledTypo-o6cwa5-0 efxBFT\"><div class=\"Badgestyled__StyledOverflow-o6cwa5-3 eVUgcy\">Promoción 3 Meses GRATIS Office 365</div></span></div></div><p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 fSoIAm\">Compra Office 365 de forma conjunta con tu nuevo portátil o PC y consigue GRATIS 3 meses extra. </p><p color=\"grey5\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gQDatN\"><a class=\"Linkstyled__StyledLinkAnchor-sc-1drhx1h-0 lkgMQP\" target=\"_blank\" rel=\"noopener noreferrer\" href=\"http://mediamarkt.es/es/specials/microsoft-365\">Obtén aquí los 3 meses extra </a></p><p color=\"grey3\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 hCkLwM\">Consigue\r\n hoy tus 3 meses extra siguiendo estos pasos: 1) Solicita en los 30 días\r\n posteriores a tu compra el código de descarga de 3 meses. 2) Selecciona\r\n \"Solicitar\" e introduce el código de 25 dígitos de tu suscripción \r\nOffice 365 (12 meses). 3) Completa los pasos de la petición y sube tu \r\nrecibo de compra. 4) Recibirás un nuevo código de suscripción de 3 meses\r\n por email en los 10 días siguientes al envío de la petición. </p></div></div><p>Con\r\n el portátil HP Laptop 14s-dq2000ns, podrás conectarte desde cualquier \r\nsitio porque viene con una gran duración de la batería. Estés donde \r\nestés, su rendimiento y amplia pantalla, te acompañarán en los días más \r\najetreados.</p><h4 color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 fBpfGp\">Rendimiento revolucionario</h4><p>Potencia la vida y el trabajo portátil con el procesador <strong>Intel® Core™ de 11ᵃ generación</strong>\r\n que ofrece un rendimiento espectacular para la productividad en las \r\ntareas generales, de estudio y de pequeñas empresas. Asegura tu \r\nmovilidad con una carga rápida, batería de larga duración y potente \r\nprocesador, un streaming fluido con el <strong>rendimiento inteligente de Intel®,</strong> una excelente experiencia de entretenimiento en 4K. Además, está equipado con <strong>8 GB de RAM DDR4 de 2666 MHz</strong> con lo que podrás trabajar con varios procesos simultáneamente sin problemas.</p><h4 color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 fBpfGp\">Pantalla FHD</h4><p>Con una <strong>pantalla de 14\" en FHD</strong> y con panel antirreflectante, podrás disfrutar de imágenes, vídeos, películas, series y más; con <strong>gran nitidez.</strong></p><h4 color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 fBpfGp\">Almacenamiento de 256 GB</h4><p>Se inicia en cuestión de segundos, con velocidad de vértigo y <strong>hasta 256 GB de almacenamiento PCIe SSD.</strong></p></div></span></div>\r\n\r\n  <div id=\"tab2_english\" class=\"tab-pane fade active in\"><table class=\"Tablestyled__StyledTable-sc-1lcy5op-0 iOnmJP\"><thead class=\"TableHeadstyled__StyledTableHead-iazyh2-0 icZHuo\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 gVkPmh\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 jYJtBV\">Pantalla</span></th><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 eBpmMV\"><br></th></tr></thead><tbody class=\"TableBodystyled__StyledTableBody-v8xzh9-0 xXwGe\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño pantalla (cm/pulg)</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">35.5 cm / 14 \"</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Resolución</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">1920 x 1080 píxeles</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Pantalla táctil</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">No</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Calidad de imagen</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">Full-HD</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño pantalla (cm)</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">35.5 cm</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño pantalla (pulgadas)      <br></span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">14 \"</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tipo de pantalla</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">IPS</td></tr><tr><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><br></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\"><br></td></tr></tbody></table><table class=\"Tablestyled__StyledTable-sc-1lcy5op-0 iOnmJP\"><thead class=\"TableHeadstyled__StyledTableHead-iazyh2-0 icZHuo\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 gVkPmh\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 jYJtBV\">Memoria RAM</span></th><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 eBpmMV\"><br></th></tr></thead><tbody class=\"TableBodystyled__StyledTableBody-v8xzh9-0 xXwGe\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tipo de RAM</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">DDR4</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño memoria RAM        <br></span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">8 GB</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Velocidad RAM</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">2666 MHz</td></tr><tr><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><br></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\"><br></td></tr></tbody></table><table class=\"Tablestyled__StyledTable-sc-1lcy5op-0 iOnmJP\"><thead class=\"TableHeadstyled__StyledTableHead-iazyh2-0 icZHuo\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 gVkPmh\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 jYJtBV\">Procesador</span></th><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 eBpmMV\"><br></th></tr></thead><tbody class=\"TableBodystyled__StyledTableBody-v8xzh9-0 xXwGe\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">Intel® Core™ i3-1115G4</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Marca del procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">Intel®</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Modelo del procesador       <br></span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">Core™ i3</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Número Procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">i3-1115G4</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Velocidad Procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">1.7 GHz</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Número de núcleos</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">2</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Vel. turbo procesador</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">4.1 GHz</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tamaño de caché</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">6 MB</td></tr></tbody></table><br><table class=\"Tablestyled__StyledTable-sc-1lcy5op-0 iOnmJP\"><thead class=\"TableHeadstyled__StyledTableHead-iazyh2-0 icZHuo\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 gVkPmh\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 jYJtBV\">Tarjeta gráfica</span></th><th class=\"TableCellstyled__StyledDataCell-y8xttg-0 eBpmMV\"><br></th></tr></thead><tbody class=\"TableBodystyled__StyledTableBody-v8xzh9-0 xXwGe\"><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Tarjeta gráfica</span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\">UHD Graphics</td></tr><tr class=\"TableRowstyled__StyledTableRow-sc-1enz63a-0 kswuNQ\" id=\"pdp-features-last-always-visible\"><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 hNWXDa\"><span class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 dJkXWj\">Fabricante Tarjeta Grafica         <br></span></td><td class=\"TableCellstyled__StyledDataCell-y8xttg-0 bSZRfq\"><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">Intel®</span></td></tr></tbody></table></div>\r\n</div>\r\n</div>info_English#','[{\"name\":\"..\\/ecommerce\\/files\\/hp_001_53vx37j9.png\",\"usrName\":\"hp_001.png\",\"size\":215027,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thhp_001_dilo43yr.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":18753,\"searchStr\":\"hp_001.png,!:sStrEnd\"}]','549.0000',0,1,'2021-08-20 13:43:14','2021-08-21 20:53:22',NULL,3,1,1),
 (10,3,4,2,4,'HP Laptop 15s-eq1033ns, 15.6\" HD, AMD 3020e','#Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">Portátil - HP Laptop 15s-eq1033ns, 15.6\" HD, AMD 3020e, 4GB, 256GB SSD, Radeon™, W10 Home, Azul índigo</p>Spanish#\r\n#English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">Portátil - HP Laptop 15s-eq1033ns, 15.6\" HD, AMD 3020e, 4GB, 256GB SSD, Radeon™, W10 Home, Azul índigo</span></p>English#\r\n\r\n<p></p>\r\n\r\n#info_Spanish<div>\r\n<ul class=\"nav nav-tabs\">\r\n  <li class=\"active\"><a data-toggle=\"tab\" href=\"#tab1_spanish\" aria-expanded=\"true\">Descripción</a></li>\r\n  <li class=\"\"><a data-toggle=\"tab\" href=\"#tab2_spanish\" aria-expanded=\"false\">Datos Técnicos</a></li>\r\n</ul>\r\n\r\n<div class=\"tab-content\">\r\n  <div id=\"tab1_spanish\" class=\"tab-pane fade active in\">\r\n    <h4>Descripción</h4>\r\n    <p>A</p></div>\r\n\r\n  <div id=\"tab2_spanish\" class=\"tab-pane fade\">\r\n    <h4>Datos Técnicos</h4>\r\n    <p>B</p>\r\n    </div>\r\n</div>\r\n</div>info_Spanish#\r\n\r\n\r\n<p></p>\r\n\r\n#info_English<div>\r\n<ul class=\"nav nav-tabs\">\r\n  <li class=\"active\"><a data-toggle=\"tab\" href=\"#tab1_english\" aria-expanded=\"true\">Description</a></li>\r\n  <li class=\"\"><a data-toggle=\"tab\" href=\"#tab2_english\" aria-expanded=\"false\">Technical data</a></li>\r\n</ul>\r\n\r\n<div class=\"tab-content\">\r\n  <div id=\"tab1_english\" class=\"tab-pane fade active in\">\r\n    <h4>Description</h4>\r\n    <p>A</p></div>\r\n\r\n  <div id=\"tab2_english\" class=\"tab-pane fade\">\r\n    <h4>Technical data</h4>\r\n    <p>B</p>\r\n    </div>\r\n</div>\r\n</div>info_English#','[{\"name\":\"..\\/ecommerce\\/files\\/hp_001_7xyxp2c5.png\",\"usrName\":\"hp_001.png\",\"size\":215027,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thhp_001_kobna79w.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":18753,\"searchStr\":\"hp_001.png,!:sStrEnd\"}]','349.0000',0,1,'2021-08-20 20:25:33','2021-08-20 20:30:04',NULL,NULL,1,1),
 (11,3,4,2,4,'HP 250 G8 15.6\" FHD, Intel® Core™ i3-1115G4','#Spanish<p color=\"black\" class=\"Typostyled__StyledInfoTypo-sc-1jga2g7-0 gvETuS\">Portátil - HP 250 G8 15.6\" FHD, Intel® Core™ i3-1115G4, 8 GB, 256 GB SSD, W10 Home, Grafito</p>Spanish#\r\n#English<p><span id=\"edit1_description_0\" class=\"bs-ctrlspan \">Portátil - HP 250 G8 15.6\" FHD, Intel® Core™ i3-1115G4, 8 GB, 256 GB SSD, W10 Home, Grafito</span></p>English#\r\n\r\n<p></p><br>','[{\"name\":\"..\\/ecommerce\\/files\\/hp_001_dwhi2ujl.png\",\"usrName\":\"hp_001.png\",\"size\":215027,\"type\":\"image\\/png\",\"thumbnail\":\"..\\/ecommerce\\/files\\/thhp_001_n0d92eh1.png\",\"thumbnail_type\":\"image\\/png\",\"thumbnail_size\":18753,\"searchStr\":\"hp_001.png,!:sStrEnd\"}]','549.0000',0,10,'2021-08-20 20:27:56','2021-08-20 20:27:56',NULL,NULL,1,1);
/*!40000 ALTER TABLE `products` ENABLE KEYS */;


--
-- Definition of table `tax`
--

DROP TABLE IF EXISTS `tax`;
CREATE TABLE `tax` (
  `id_tax` int(11) NOT NULL AUTO_INCREMENT,
  `tax_code` varchar(20) NOT NULL,
  `tax_amount` decimal(10,2) NOT NULL,
  `Description` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id_tax`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `tax`
--

/*!40000 ALTER TABLE `tax` DISABLE KEYS */;
INSERT INTO `tax` (`id_tax`,`tax_code`,`tax_amount`,`Description`) VALUES 
 (1,'Reducido - 10%','10.00','IVA reducido'),
 (2,'General - 21%','21.00','IVA General');
/*!40000 ALTER TABLE `tax` ENABLE KEYS */;


--
-- Definition of table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id_users` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) NOT NULL,
  `password` varchar(60) NOT NULL,
  `name` varchar(65) NOT NULL,
  PRIMARY KEY (`id_users`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`id_users`,`login`,`password`,`name`) VALUES 
 (1,'admin','21232f297a57a5a743894a0e4a801fc3','Administraor'),
 (2,'gestor','a55607442fca264cf37e935503d646c2','Usuario Gestor');
/*!40000 ALTER TABLE `users` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
